% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__WOA.R
\name{config_woa}
\alias{config_woa}
\title{Configuration object for the Whale Optimization Algorithm}
\usage{
config_woa(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of whales.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}
}
\value{
\code{config_woa} returns an object of class \code{WOAConfig}.
}
\description{
Create a configuration object for the Whale Optimization Algorithm (WOA). At minimum the number of iterations
(parameter \code{iterations}) and the number of whales (parameter \code{population_size}) have
to be provided.
}
\examples{
conf <- config_woa(iterations = 100, population_size = 50, iterations_same_cost = NULL,
absolute_tol = NULL)

}
\references{
\insertRef{MIRJALILI201651}{EmiR}
}
