% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LICnew.R
\encoding{UTF-8}
\name{LICnew}
\alias{LICnew}
\title{Calculate the LIC estimator based on A-optimal and D-optimal criterion}
\usage{
LICnew(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{A matrix of observations (design matrix) with size n x p}

\item{Y}{A vector of responses with length n}

\item{alpha}{The significance level for confidence intervals}

\item{K}{The number of subsets to consider}

\item{nk}{The size of each subset}
}
\value{
A list containing:
\item{E5}{The LIC estimator based on A-optimal and D-optimal criterion.}
}
\description{
Calculate the LIC estimator based on A-optimal and D-optimal criterion
}
\examples{
p = 6; n = 1000; K = 2; nk = 200; alpha = 0.05; sigma = 1
e = rnorm(n, 0, sigma); beta = c(sort(c(runif(p, 0, 1))));
data = c(rnorm(n * p, 5, 10)); X = matrix(data, ncol = p);
Y = X \%*\% beta + e;
LICnew(X = X, Y = Y, alpha = alpha, K = K, nk = nk)
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}

Guo, G., Sun, Y., Qian, G., & Wang, Q. (2022). LIC criterion for optimal subset selection in distributed interval estimation. \emph{Journal of Applied Statistics}, 50(9), 1900-1920. \doi{10.1080/02664763.2022.2053949}.

Chang, D., Guo, G. (2024). LIC: An R package for optimal subset selection for distributed data. \emph{SoftwareX}, 28, 101909.

Jing, G., & Guo, G. (2025). TLIC: An R package for the LIC for T distribution regression analysis. \emph{SoftwareX}, 30, 102132.

Chang, D., & Guo, G. Research on Distributed Redundant Data Estimation Based on LIC. \emph{IAENG International Journal of Applied Mathematics}, 55(1), 1-6 (2025).

Gao, H., & Guo, G. LIC for Distributed Skewed Regression. \emph{IAENG International Journal of Applied Mathematics}, 55(9), 2925-2930 (2025).

Zhang, C., & Guo, G. (2025). The optimal subset estimation of distributed redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 270-277.

Jing, G., & Guo, G. (2025). Student LIC for distributed estimation. \emph{IAENG International Journal of Applied Mathematics}, 55(3), 575-581.

Liu, Q., & Guo, G. (2025). Distributed estimation of redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 332-337.
}
