simplexreg.fit <-
function(y, x, z = NULL, t = NULL, link = "logit", corr = "Ind",
	id = NULL, control = simplexreg.control())
{   
   	maxit <- control$maxit
	tol <- control$tol
	beta <- control$beta
	gamma <- control$gamma
	alpha <- control$alpha
    if (all(z==1)||is.null(z))
        type <- "homo"
    else
        type <- "hetero"
	if (length(y) < 1)
   	    stop("empty model")
   	if (min(y) <= 0 || max(y) >= 1)
   	   	stop("observations must be in (0, 1)")
   	if (link == "logit"){link = 1}
   	else if (link == "probit"){link = 2}
   	else if (link == "cloglog"){link = 3}
   	else if (link == "neglog"){link = 4}
   	else stop("Undefined type of link function")
   	if (corr == "Ind"){
   	   	if (type == "homo"){simglm1(y, x, link, beta, maxit, tol)}
   	   	else {simglm2(y, x, z, link, beta, gamma, maxit, tol)}
   	}
   	else{
   	   	if (corr == "AR1")
   	   	   	corr <- 0
   	   	else
   	   	   	corr <- 1
   	   	id <- factor(id)
   	   	if (!is.null(alpha)){
   	   	   	alpha <- alpha[1]
   	   	   	if (alpha > 0)
   	   	   	   	alpha <- NULL
   	   	}
   	   	if (type == "homo"){simgee1(y, x, t, id, link, corr, beta, alpha, maxit, tol)}
   	   	else {simgee2(y, x, z, t, id, link, corr, beta, gamma, alpha, maxit, tol)}
   	}
}