% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPairsBoot.R
\name{runPairsBoot}
\alias{runPairsBoot}
\title{The bootstrap uncertainty analysis for runPairs results}
\usage{
runPairsBoot(eList, pairResults, nBoot = 100, startSeed = 494817,
  blockLength = 200, jitterOn = FALSE, V = 0.2, run.parallel = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{pairResults}{data frame returned from \code{\link[EGRET]{runPairs}}}

\item{nBoot}{the maximum number of bootstrap replicates to be used, typically 100}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}

\item{blockLength}{integer size of subset, expressed in days.  200 days has been found to be a good choice.}

\item{jitterOn}{logical, if TRUE, adds "jitter" to the data in an attempt to avoid some numerical problems.  Default = FALSE.  See Details below.}

\item{V}{numeric a multiplier for addition of jitter to the data, default = 0.2.}

\item{run.parallel}{logical to run bootstrapping in parallel or not}
}
\value{
eBoot, a named list with bootOut, wordsOut, xConc, xFlux, pConc, pFlux values.
\itemize{
  \item{bootOut is a data frame with the results of the bootstrap test. }
  \item{wordsOut is a character vector describing the results.}
  \item{xConc and xFlux are vectors of length iBoot, of the change in flow normalized concentration
   and flow normalized flux computed from each of the bootstrap replicates. }
  \item{pConc and pFlux are vectors of length iBoot, of the change in flow normalized concentration
   or flow normalized flux computed from each of the bootstrap replicates expressed as \% change.}
}
}
\description{
The function that does the uncertainty analysis for determining the change between any 
pair of years.  It is very similar to the \code{\link{wBT}} function that runs the WRTDS 
bootstrap test.  It differs from \code{\link{wBT}} in that it runs a specific number of 
bootstrap replicates, unlike the \code{\link{wBT}} approach that will stop running replicates 
based on the status of the test statistics along the way.  Also, this code can be used with
generalized flow normalization, which handles non-stationary discharge, 
whereas \code{\link{wBT}} does not.
}
\details{
In some situations numerical problems are encountered in the bootstrap process, resulting in highly unreasonable spikes in the confidence intervals.
The use of "jitter" can often prevent these problems, but should only be used when it is clearly needed.
It adds a small amount of random "jitter" to the explanatory variables of the WRTDS model.  The V parameter sets the scale of variation in the log discharge values.
The standard deviation of the added jitter is V * standard deviation of Log Q.
The default for V is 0.2.  Larger values should generally be avoided, and smaller values may be sufficient.
}
\examples{
eList <- EGRET::Choptank_eList
year1 <- 1985
year2 <- 2009

\dontrun{
pairOut_2 <- EGRET::runPairs(eList, 
                             year1, year2, 
                             windowSide = 7)

# For good analysis, bump up nBoot to about 100:
boot_pair_out <- runPairsBoot(eList, pairOut_2, nBoot = 5)

plotHistogramTrend(eList, boot_pair_out)

boot_message(eList, pairOut_2, boot_pair_out)
}
}
\seealso{
\code{\link{runGroupsBoot}}, \code{\link[EGRET]{runPairs}}
}
