% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{fct_yesno}
\alias{fct_yesno}
\title{Format factor levels as Yes/No}
\usage{
fct_yesno(
  x,
  input = list(yes = c("Yes", "Oui"), no = c("No", "Non"), na = c("NA", "")),
  output = c("Yes", "No"),
  strict = FALSE,
  mutate_character = TRUE,
  fail = TRUE
)
}
\arguments{
\item{x}{a vector of any type/class.}

\item{input}{list of values to be considered as "yes", "no", and \code{NA}.}

\item{output}{the output factor levels.}

\item{strict}{whether to match the input strictly or use \link[stringr:str_detect]{stringr::str_detect} to find them. Can also be "ignore_case" to just ignore the case.}

\item{mutate_character}{whether to turn characters into factor.}

\item{fail}{whether to fail if some levels cannot be recoded to yes/no.}
}
\value{
a factor, or \code{x} untouched.
}
\description{
Format factor levels as arbitrary values of Yes/No (with Yes always first) while \strong{leaving untouched} all vectors that contain other information.
}
\examples{

fct_yesno(c("No", "Yes")) #levels are in order

set.seed(42)
N=6
x = tibble(
  a=sample(c("Yes", "No"), size=N, replace=TRUE),
  b=sample(c("Oui", "Non"), size=N, replace=TRUE),
  c=sample(0:1, size=N, replace=TRUE),
  d=sample(c(TRUE, FALSE), size=N, replace=TRUE),
  e=sample(c("1-Yes", "0-No", "2-NA"), size=N, replace=TRUE),
  
  y=sample(c("aaa", "bbb", "ccc"), size=N, replace=TRUE),
  z=1:N,
)
 
x          
#y and z are left untouched (or throw an error if fail=TRUE)   
sapply(x, fct_yesno, fail=FALSE, simplify=FALSE)

# as "1-Yes" is not in `input`, x$e is untouched/fails if strict=TRUE
fct_yesno(x$e)
fct_yesno(x$e, strict=TRUE, fail=FALSE) 
fct_yesno(x$e, output=c("Ja", "Nein"))
}
