% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discreteT.R
\name{discreteT}
\alias{discreteT}
\title{Compute test statistics for the DRPT in discrete settings.}
\usage{
discreteT(NX, NY, r, n, m, type = "V")
}
\arguments{
\item{NX}{A vector of counts for the first sample.
This corresponds to the sequence \eqn{\mathrm{tot}_j - N_{Y,j}^p} with
\eqn{p = \mathrm{id}}, i.e. the identity permutation,
as introduced in Section 2.1 of \insertCite{BB2025DRPT;textual}{DRPT}.}

\item{NY}{A vector of counts for the second sample.
This corresponds to the sequence \eqn{N_{Y,j}^p} with
\eqn{p = \mathrm{id}}, i.e. the identity permutation,
as introduced in Section 2.1 of \insertCite{BB2025DRPT;textual}{DRPT}.}

\item{r}{A numeric vector of positive values specifying the hypothesised density ratio
in the discrete setting.}

\item{n}{The size of the first sample.}

\item{m}{The size of the second sample.}

\item{type}{A character string indicating which test statistic to compute.
One of \code{"U"}, \code{"V"}, or \code{"D"}. See the Details section for more information.
Defaults to \code{"V"}.}
}
\value{
A numeric value representing the computed test statistic.
}
\description{
Computes the test statistics introduced in \insertCite{BB2025DRPT;textual}{DRPT}
for settings where the data support is discrete and finite.
}
\details{
When \code{type = "U"}, the U-statistic (12) is calculated.
When \code{type = "V"}, the V-statistic (11) is computed.
When \code{type = "D"}, the test statistic (56) from Appendix B is returned.
}
\examples{
n = 100; m = n
X = sample(0:3, n, prob = c(1/4, 1/4, 1/4, 1/4), replace = TRUE)
Y = sample(0:3, m, prob = c(1/17, 3/17, 3/17, 10/17), replace = TRUE)
r = c(1, 3, 3, 10)

NX = table(X)
NY = table(Y)

discreteT(NX, NY, r, sum(NX), sum(NY), type = "V")
discreteT(NX, NY, r, sum(NX), sum(NY), type = "D")
}
\references{
\insertRef{BB2025DRPT}{DRPT}
}
