% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvival.R
\name{plotSurvival}
\alias{plotSurvival}
\title{Plot survival results}
\usage{
plotSurvival(
  result,
  ribbon = TRUE,
  facet = NULL,
  colour = NULL,
  cumulativeFailure = FALSE,
  riskTable = FALSE,
  riskInterval = 30,
  logLog = FALSE,
  timeScale = "days",
  style = NULL
)
}
\arguments{
\item{result}{Survival results}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{cumulativeFailure}{whether to plot the cumulative failure probability
instead of the survival probability}

\item{riskTable}{Whether to print risk table below the plot}

\item{riskInterval}{Interval of time to print risk table below the plot}

\item{logLog}{If TRUE, the survival probabilities are transformed using the log-log formula}

\item{timeScale}{The scale of time in the x-axis. Can be "days", "months", or "years"}

\item{style}{A character string defining the visual theme to apply to the plot.
You can set this to NULL to apply the standard ggplot2 default style, or provide
a name for one of the package's pre-defined styles. Refer to the plotStyle() function
for all available style pre-defined themes. For further customization, you can always
modify the returned ggplot object directly.}
}
\value{
A plot of survival probabilities over time
}
\description{
Plot survival results
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
plotSurvival(surv)
}

}
