% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_out_subgraphs.R
\name{split_out_subgraphs}
\alias{split_out_subgraphs}
\title{Split adjacency matrix into subgraphs}
\usage{
split_out_subgraphs(adjacency_matrix)
}
\arguments{
\item{adjacency_matrix}{An adjacency matrix where the diagonal is zeroes and the off-diagonal either ones (if the two vertices are directly connected) or zeroes (if not directly connected).}
}
\value{
A list of all connected subgraphs represented as adjacency matri(ces).
}
\description{
Given a graph represented by an adjacency matrix splits into all connected subgraphs.
}
\details{
This functions take any undirected graph (connected or unconnected) represented as an adjacency matrix and identifies all connected subgraphs and returns these as a list of adjacency matr(ices).
}
\examples{

# Create an adjacency matrix representing an unconnected graph:
adjacency_matrix <- matrix(
  data = c(
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 0, 0, 1,
    0, 1, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 0, 0
  ),
  ncol = 6,
  byrow = TRUE,
  dimnames = list(LETTERS[1:6], LETTERS[1:6])
)

# Check graph is connected:
split_out_subgraphs(adjacency_matrix = adjacency_matrix)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
