% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_cladistic_matrix.R
\name{prune_cladistic_matrix}
\alias{prune_cladistic_matrix}
\title{Prunes a character matrix of characters or taxa}
\usage{
prune_cladistic_matrix(
  cladistic_matrix,
  blocks2prune = c(),
  characters2prune = c(),
  taxa2prune = c(),
  remove_invariant = FALSE
)
}
\arguments{
\item{cladistic_matrix}{The cladistic matrix in the format imported by \link{read_nexus_matrix}.}

\item{blocks2prune}{A vector of number(s) of any blocks to prune.}

\item{characters2prune}{A vector of character numbers to prune.}

\item{taxa2prune}{A vector of taxon names to prune (these must be present in \code{rownames(x = cladistic_matrix$matrix}).}

\item{remove_invariant}{A logical for whether invariant characters should (TRUE) or should not (FALSE, default) be pruned.}
}
\description{
Prunes a character matrix of characters, taxa, or both.
}
\details{
Removing characters or taxa from a matrix imported using \link{read_nexus_matrix} is not simple due to associated vectors for ordering, character weights etc. To save repetitively pruning each part this function takes the matrix as input and vector(s) of either block numbers, character numbers, taxon names, or any combination thereof and returns a matrix with these items removed. Minimum and maximum values (used by \link{calculate_morphological_distances}) are also updated and the user has the option to remove constant characters this way as well (e.g, to reduce the memory required for a DNA matrix).
}
\examples{

# Remove the outgroup taxon and characters 11 and 53 from gauthier_1986:
prunedmatrix <- prune_cladistic_matrix(
  cladistic_matrix =
    gauthier_1986, characters2prune = c(11, 53), taxa2prune =
    c("Outgroup")
)

# Show priuned matrix:
prunedmatrix$matrix_1$matrix
}
\seealso{
\link{build_cladistic_matrix}, \link{compactify_cladistic_matrix}, \link{read_nexus_matrix}, \link{safe_taxonomic_reduction}, \link{write_nexus_matrix}, \link{write_tnt_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
