\name{nntsmeasureslocationdispersion}
\alias{nntsmeasureslocationdispersion}
\title{Moments of an NNTS density}
\description{Computes the first moment, second moment, mean direction, dispersion, circular varance, coefficient of
asymmetry and kurtosis from the given parameters of an NNTS density.}
\usage{nntsmeasureslocationdispersion(cestimates,M=0)}
\arguments{
  \item{cestimates}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter vecto (or c estimates) of the NNTS model}
  \item{M}{Number of components in the NNTS density}
}
\value{
  \item{firstmoment}{Value of the first trigonometric moment}
  \item{secondmoment}{Value of the second trigonometric moment}
  \item{meandirection}{Value of the mean direction}
  \item{dispersion}{Value of the dispersion}
  \item{circularvariance}{Value of the circular variance}
  \item{asymmetrycoefficient}{Value of the coefficient of asymmetry}
  \item{kurtosis}{Value of the kurtosis}
}
\references{
Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME]
(available at https://arxiv.org/abs/2412.19501)
}
\author{Juan Jose Fernandez-Duran y Maria Mercedes Gregorio-Dominguez}
\examples{
data(Ants_radians)
resants<-nntsmanifoldnewtonestimationgradientstop(data=Ants_radians, M = 2, iter=1000,
gradientstop=1e-10)
resants
nntsmeasureslocationdispersion(resants$cestimates,M=2)
}
