% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureFuncs.R
\name{extractSegsize}
\alias{extractSegsize}
\alias{extractBP10MB}
\alias{extractOscillations}
\alias{extractBPChrArm}
\alias{extractChangepoints}
\alias{extractCN}
\title{featureFuncs}
\usage{
extractSegsize(segData)

extractBP10MB(segData, chrlen)

extractOscillations(segData, chrlen)

extractBPChrArm(segData, centromeres, chrlen)

extractChangepoints(segData, centromeres, chrlen)

extractCN(segData)
}
\arguments{
\item{segData}{The samples to extract data from}

\item{chrlen}{The lengths of the chromosomes from reference genome}

\item{centromeres}{The positions of the centromeres in reference genome}
}
\description{
This group of functions return vectors of the corresponding features for
the samples passed in. Some of the functions use internal datasets to the
CNSig package that specify the chromosome lengths and the centromere 
positions.
}
\section{extractSegsize}{

This function returns a vector of all the segment sizes for all for all
of the samples.
}

\section{extractBP10MB}{

This function returns a vector of the average number of breakpoints in a per
10MB for each chromosome.
}

\section{extractOscillations}{

This function returns a vector of number of oscillation events found on
each of the chromosomes.
}

\section{getBPChrArm}{

This function returns a vector of number of total breakpoints per chromosome
arm.
}

\section{extractChangepoints}{

This function returns a vector of average size of changepoints per chromosome
}

\section{extractCN}{

This function returns a vector of average copynumber per chromosome
}

