% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariable.clogmodels.R
\name{univariable.clogmodels}
\alias{univariable.clogmodels}
\title{Univariable Conditional Logistic Regression Models}
\usage{
univariable.clogmodels(
  data,
  yval,
  xval,
  strata,
  OR = FALSE,
  inc.or = NULL,
  confidence.level = 0.95
)
}
\arguments{
\item{data}{A data frame containing the outcome, predictors, and strata variables}

\item{yval}{A string indicating the name of the binary outcome variable.}

\item{xval}{A character vector of predictor variable names for which univariable models will be fit.}

\item{strata}{A character string specifying the name of the stratification variable (e.g., matching ID).}

\item{OR}{Logical; if TRUE, odds ratios and their confidence intervals are returned. Default to FALSE.}

\item{inc.or}{A numeric vector specifying the unit increment to apply when calculating odds ratios for each coefficient.
Required if \code{OR = TRUE}. The length of \code{inc.or} must match the number of coefficients produced across all univariable models
(including dummy variables for factor levels, if applicable). It must align with the order of \code{xval}: for each variable,
include one value per resulting coefficient.}

\item{confidence.level}{The confidence level to use for interval estimation of odds ratios. Defaults to 0.95.}
}
\value{
A data frame with coefficients from the univariable models, standard errors, p-values, and, if requested, odds ratios with lower and upper confidence limits.
}
\description{
This function fits separate univariable conditional logistic regression models for a specified outcome and a
list of explanatory variables, using the \code{clogit} function from the \code{survival} package. It returns a summary
table with coefficients, standard errors, p-values, and optionally odds ratios with confidence intervals.
The strata vector must be in the same order as the observations in the \code{data} frame.
}
\details{
Each predictor in \code{xval} is fit in a separate model with the outcome and stratification variable.
When \code{OR = TRUE}, the user must supply \code{inc.or}, a vector of increments matching the number of coefficients
across all univariable models (i.e., including levels of factors if applicable). The function assumes that
the outcome is binary and numeric (0/1); it will attempt to coerce it if not.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 7, Table 7.1

 # Convert 'fracture' to binary (0 = No, 1 = Yes)
glow11m$fracture <- ifelse(glow11m$fracture == "Yes", 1, 0)

# Define variables to evaluate
unvariables <- c(
  "height", "weight", "bmi", "priorfrac", "premeno", "momfrac",
  "armassist", "smoke", "raterisk")

# Define value ranges used to interpret odds ratios (Optional)
val.pe <- c(10, 10, 3, 1, 1, 1, 1, 1, 1, 1)

# Run univariable conditional logistic regressions
univariable.clogmodels(glow11m, yval = 'fracture', xval = unvariables,
                        strata = 'pair', OR = TRUE, inc.or = val.pe)

}
