% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_banks.R
\name{get_brazil_banks}
\alias{get_brazil_banks}
\title{Get List of Banks in Brazil}
\usage{
get_brazil_banks()
}
\value{
A tibble (data frame) with the following columns:
\itemize{
  \item \code{code}: Bank code (integer).
  \item \code{name}: Short name of the bank.
  \item \code{fullName}: Full registered name of the bank.
  \item \code{ispb}: ISPB code (Identificador do Sistema de Pagamentos Brasileiros).
}
}
\description{
This function retrieves the list of all banks in Brazil from the BrasilAPI endpoint:
`https://brasilapi.com.br/api/banks/v1`. The response includes key details such as
bank code, name, and ISPB (identificador do sistema de pagamentos).
}
\note{
Requires internet connection. The function pulls data in real time from BrasilAPI.
}
\examples{
\dontrun{
banks <- get_brazil_banks()
head(banks)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
