% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARObjectClass.R
\docType{class}
\name{BigVAR.intermediate}
\alias{BigVAR.intermediate}
\alias{BigVAR.intermediate-class}
\title{BigVAR.intermediate
This class contains the in-sample results for cv.BigVAR}
\description{
It inherits the class BigVAR, and contains the results from rolling validation
}
\section{Fields}{

\describe{
\item{\code{ZFull}}{List containing full lag matrix and time series}

\item{\code{InSampMSFE}}{In-sample MSFE from optimal value of lambda}

\item{\code{LambdaGrid}}{Grid of candidate lambda values}

\item{\code{index}}{Index order of optimal lambda value}

\item{\code{OptimalLambda}}{Value of lambda that minimizes MSFE}

\item{\code{Data}}{a \eqn{T \times k} or \eqn{T\times k + m} multivariate time Series}

\item{\code{lagmax}}{Maximal lag order}

\item{\code{Structure}}{Penalty structure}

\item{\code{Relaxed}}{Indicator for relaxed VAR}

\item{\code{Granularity}}{Granularity of penalty grid}

\item{\code{horizon}}{Desired forecast horizon}

\item{\code{crossval}}{Cross-Validation procedure}

\item{\code{alpha}}{additional penalty parameter for Sparse Lag Group or Sparse Own/Other methods. Will contain either the heuristic choice of \eqn{1/(k+1)} or the value selected by cross validation if the argument \code{dual} is set to \code{TRUE}}

\item{\code{Minnesota}}{Minnesota Prior Indicator}

\item{\code{verbose}}{verbose indicator}

\item{\code{dual}}{indicator as to whether dual cross validation was conducted}

\item{\code{contemp}}{indicator if contemporaneous exogenous predictors are used}
}}

\note{
One can also access any object of class BigVAR from BigVAR.intermediate
}
\author{
Will Nicholson
}
