% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCheckMatrix_hdf5}
\alias{bdCheckMatrix_hdf5}
\title{Check Matrix Suitability for Eigenvalue Decomposition with Spectra}
\usage{
bdCheckMatrix_hdf5(
  filename,
  group = NULL,
  dataset = NULL,
  check_symmetry = NULL,
  tolerance = NULL,
  sample_size = NULL
)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file containing the matrix.}

\item{group}{Character string. Path to the group containing the dataset.}

\item{dataset}{Character string. Name of the dataset to check.}

\item{check_symmetry}{Logical. Whether to check if the matrix is symmetric (default = TRUE).}

\item{tolerance}{Numeric. Tolerance for symmetry checking (default = 1e-12).}

\item{sample_size}{Integer. Number of elements to sample for large matrices (default = 1000).}
}
\value{
A list with matrix properties and suitability assessment.
}
\description{
Checks whether a matrix stored in HDF5 format is suitable for eigenvalue decomposition
using Spectra. The function verifies that the matrix is square and optionally checks
for symmetry to recommend the best solver type.
}
\examples{
\dontrun{
# Check matrix suitability
check_result <- bdEigen_check_matrix("data.h5", "matrices", "my_matrix")

if (check_result$suitable_for_eigen) {
  # Use appropriate solver based on recommendation
  if (check_result$recommended_solver == "symmetric") {
    result <- bdEigen_hdf5("data.h5", "matrices", "my_matrix", which = "LA")
  } else {
    result <- bdEigen_hdf5("data.h5", "matrices", "my_matrix", which = "LM")
  }
} else {
  cat("Matrix is not suitable for eigendecomposition\n")
}
}

}
