% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFSAcriteria.R
\name{criteriaCheck}
\alias{criteriaCheck}
\title{Computes PPC and NRMSE as defined in EFSA 2018}
\usage{
criteriaCheck(x)
}
\arguments{
\item{x}{an object of class \code{beeSurvFit} or \code{beeSurvPred}}
}
\value{
The function returns a list with three items:
\item{PPC}{The criterion, in percent, compares the predicted median number of survivors associated
to their uncertainty limits with the observed numbers of survivors.
Based on experience, PPC resulting in more than \eqn{50\%} of the
observations within the uncertainty limits indicate good model performance (EFSA 2018). A fit of
\eqn{100\%} may hide too large uncertainties of prediction (so covering all data).}
\item{NRMSE}{The criterion, in percent, is based on the classical root-mean-square error (RMSE),
used to aggregate the magnitudes of the errors in predictions for various time-points
into a single measure of predictive power. In order to provide a criterion expressed
as a percentage, NRMSE is the normalised RMSE by the mean of the observations.
EFSA (2018) recognised that a NRMSE of less than 50\% indicates good model performance}
\item{SPPE}{A list with the Survival Probability Prediction Error per dataset and condition.
Each dataset is in a sublist.}

@references
EFSA PPR Scientific Opinion (2018)
\emph{Scientific Opinion on the state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for regulatory risk assessment of pesticides for aquatic organisms}
\url{https://efsa.onlinelibrary.wiley.com/doi/10.2903/j.efsa.2018.5377}

@example
data(fitBetacyfluthrin_Chronic)
out <- criteriaCheck(fitBetacyfluthrin_Chronic)
}
\description{
Computes PPC and NRMSE as defined in EFSA 2018
}
