% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_state_space.R
\name{bi.dist.gaussian_state_space}
\alias{bi.dist.gaussian_state_space}
\title{Gaussian State Space Distribution}
\usage{
bi.dist.gaussian_state_space(
  num_steps,
  transition_matrix,
  covariance_matrix = py_none(),
  precision_matrix = py_none(),
  scale_tril = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{num_steps}{An integer representing the number of steps.}

\item{transition_matrix}{A numeric vector, matrix, or array representing the state space transition matrix \eqn{A}.}

\item{covariance_matrix}{A numeric vector, matrix, or array representing the covariance of the innovation noise \eqn{\epsilon}.  Defaults to `reticulate::py_none()`.}

\item{precision_matrix}{A numeric vector, matrix, or array representing the precision matrix of the innovation noise \eqn{\epsilon}. Defaults to `reticulate::py_none()`.}

\item{scale_tril}{A numeric vector, matrix, or array representing the scale matrix of the innovation noise \eqn{\epsilon}. Defaults to `reticulate::py_none()`.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector, matrix, or array representing an optional boolean array to mask observations. Defaults to `reticulate::py_none()`.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape. When `sample=FALSE` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=TRUE` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site. Defaults to `FALSE`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
When `sample=FALSE`:
 - When `sample=FALSE`, a BI  Gaussian State Space distribution object (for model building).

 - When `sample=TRUE`, a JAX array of samples drawn from the  Gaussian State Space distribution (for direct sampling).

 - When `create_obj=TRUE`, the raw BI distribution object (for advanced use cases).
}
\description{
Samples from a Gaussian state space model.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.gaussian_state_space(
  num_steps = 1,
  transition_matrix = matrix(c(0.5), nrow = 1, byrow = TRUE),
  covariance_matrix = matrix(c(1.0), nrow = 1, byrow = TRUE),
  sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#gaussianstatespace}
}
