% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{GLES}
\alias{GLES}
\title{German Longitudinal Election Study (GLES)}
\format{
A list containing data from the German Longitudinal Election Study with 2003 
(partly incomplete) observations. 
The list contains both information on the response (paired comparisons) and different covariates.
\describe{ 
\item{Y}{A response.BTLLasso object for the GLES data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named party per paired comparison}
\item{second.object: Vector containing the second-named party per paired comparison}
\item{subject: Vector containing a person identifier per paired comparison}
\item{with.order} Automatically generated vector containing information on order effect. Irrelevant, because 
no order effect needs to be included in the analysis of GLES data. 
}}
\item{X}{Matrix containing all eight person-specific covariates
\itemize{
\item{Age: Age in years} 
\item{Gender (0: male, 1: female)}
\item{EastWest (0: West Germany, 1: East Germany)}
\item{PersEcon: Personal economic situation, 1: good or very good,
0: else} 
\item{Abitur: School leaving certificate, 1: Abitur/A
levels, 0: else} 
\item{Unemployment: 1: currently unemployed, 0:
else} 
\item{Church: Frequency of attendence in a
church/synagogue/mosque/..., 1: at least once a month, 0: else}
\item{Migration: Are you a migrant / not German since birth? 1: yes,
0: no} 
}
}
\item{Z1}{Matrix containing all four person-party-specific covariates
\itemize{
\item{Climate: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards climate change.}
\item{SocioEcon: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards socio-economic issues.}
\item{Immigration: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards immigration.}
}
}
}
}
\source{
\url{https://www.gesis.org/en/gles/about-gles}
}
\description{
Data from the German Longitudinal Election Study (GLES), see Rattinger et
al. (2014). The GLES is a long-term study of the German electoral process.
It collects pre- and post-election data for several federal elections, the
data used here originate from the pre-election study for 2013.
}
\examples{
\dontrun{
op <- par(no.readonly = TRUE)

data(GLES)
Y <- GLES$Y
X <- scale(GLES$X, scale = FALSE)

subs <- c("(in years)","female (1); male (0)","East Germany (1); West Germany (0)",
          "(very) good (1); else (0)", "Abitur/A levels (1); else (0)", 
          "currently unemployed (1); else (0)","at least once a month (1); else (0)",
          "yes (1); no (0)")

set.seed(5)
m.gles <- cv.BTLLasso(Y = Y, X = X, control = ctrl.BTLLasso(l.lambda = 50))

par(xpd = TRUE, mar = c(5,4,4,6))
plot(m.gles, subs.X = subs)

par(op)
}

}
\references{
Rattinger, H., S. Rossteutscher, R. Schmitt-Beck, B. Wessels,
and C. Wolf (2014): Pre-election cross section (GLES 2013). \emph{GESIS Data
Archive, Cologne ZA5700 Data file Version 2.0.0.}

Schauberger, Gunther and Tutz, Gerhard (2019): BTLLasso - A Common Framework and Software 
Package for the Inclusion  and Selection of Covariates in Bradley-Terry Models, \emph{Journal of 
Statistical Software}, to appear

Schauberger, Gunther and Tutz, Gerhard (2017): Subject-specific modelling 
of paired comparison data: A lasso-type penalty approach, \emph{Statistical Modelling},
17(3), 223 - 243
}
\keyword{datasets}
