% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-Model.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate}
\usage{
evaluate(object, data = NULL, data_path = NULL, metric = rmse)
}
\arguments{
\item{object}{A fitted BKT model object. This is the model to be evaluated.}

\item{data}{Data frame. The dataset on which the model will be evaluated. If \code{data} is not provided,
the function will attempt to load the dataset from the file specified by \code{data_path}.}

\item{data_path}{Character. The file path to the dataset for evaluation. This will be used if \code{data} is not provided.}

\item{metric}{Function or Function List. The evaluation metric used to assess the model performance.
(Root Mean Square Error), but other metrics can also be specified.}
}
\value{
Numeric or List. The result of the evaluation based on the specified metric(s). For example, if \code{rmse} is used,
the function will return the root mean square error for the model on the dataset.
}
\description{
Evaluate a BKT (Bayesian Knowledge Tracing) model using a specified metric.
This function evaluates a fitted BKT model on a given dataset using a chosen performance metric.
It takes either a data frame or a file path to the data and returns the evaluation result
based on the specified metric (e.g., RMSE or accuracy).
}
\examples{
\donttest{
model <- bkt(seed = 42, parallel = TRUE, num_fits = 5)
result <- fit(model, data_path = "ct.csv", skills = "Plot non-terminating improper fraction")
eval_result <- evaluate(result, data_path = "ct_test.csv", metric = rmse)
print(eval_result)
}
}
