% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreBe.R
\name{exploreBe}
\alias{exploreBe}
\title{Explore BE identifiers}
\usage{
exploreBe(
  id,
  source,
  be,
  showBE = FALSE,
  showProbes = FALSE,
  showLegend = TRUE
)
}
\arguments{
\item{id}{one ID for the BE}

\item{source}{the ID source database. \strong{Guessed if not provided}}

\item{be}{the type of BE. \strong{Guessed if not provided}}

\item{showBE}{boolean. If TRUE the Biological Entity corresponding to the
id is shown. If id is isolated (not mapped to any other ID or symbol)
BE is shown anyway.}

\item{showProbes}{boolean. If TRUE, probes targeting any BEID are shown.}

\item{showLegend}{boolean. If TRUE the legend is displayed.}
}
\description{
This function uses visNetwork to draw all the identifiers
corresponding to one BE (including ProbeID and BESymbol)
}
\examples{
\dontrun{
exploreBe("Gene", "100", "EntrezGene")
}

}
