% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumry.default.R
\name{sumry.default}
\alias{sumry.default}
\title{Summary Descriptive Statistics for List or Data Frame}
\usage{
\method{sumry}{default}(
  x,
  ...,
  transpose = FALSE,
  pad = 2,
  maxsum = 10,
  opts = list(digits = 4, scipen = 2)
)
}
\arguments{
\item{x}{A data frame, list, or vector containing variables to summarize. A vector is treated as a single variable data frame. Unnamed variables receive generic names like \code{V1}, \code{V2}, etc.}

\item{...}{Additional arguments (not currently used).}

\item{transpose}{A logical controlling report format. By default the table printed is organized to show variables in columns and their statistic values in rows. Setting \code{transpose = TRUE} prints the transposed table with variables in rows and statistics in columns.}

\item{pad}{A positive integer for the number of spaces between output columns.}

\item{maxsum}{A positive integer limiting the number of levels for factor reports.}

\item{opts}{A key=value type list, optional input for \code{options} values on output. Existing values are restored on exit.}
}
\value{
Invisibly returns a list containing a summary data frame for each variable with no rounding. For example,  \code{smry <- sumry.df(df[c("A", "B", "C")]); smry$A$std.dev} gives the standard deviation of variable \code{A} in data frame \code{df}
}
\description{
Computes and prints summary descriptive statistics for each variable in a data frame, list, or vector including counts, numeric summaries (min, quartiles, mean, max, standard deviation), and factor summaries (levels and frequencies).
}
\details{
For each variable in \code{x}, the function computes the count of non-missing and missing values. Numeric variables are summarized by minimum, first quartile, median, mean, third quartile, maximum, and standard deviation. Factor, logical, and character variables are summarized by level frequencies, where level names may be abbreviated for readability. Results are formatted in a table and printed. The function returns a list containing numeric or factor summaries for each variable.
}
\examples{
sumry(penguins)
sumry(data.frame(a = rnorm(100),
                 b = c(NA, 1:98, NA),
                 c = sample(letters[4:6], 100, TRUE)),
                 transpose = TRUE, pad = 1)
}
