% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/price_impact_utils.R
\name{compute_adjusted_factors}
\alias{compute_adjusted_factors}
\title{Compute Adjusted Up and Down Factors}
\usage{
compute_adjusted_factors(u, d, lambda, v_u, v_d)
}
\arguments{
\item{u}{Base up factor}

\item{d}{Base down factor}

\item{lambda}{Price impact coefficient}

\item{v_u}{Hedging volume on up move}

\item{v_d}{Hedging volume on down move}
}
\value{
List with elements \code{u_tilde} and \code{d_tilde}
}
\description{
Calculates the modified up and down factors after incorporating
price impact from hedging.
}
\examples{
compute_adjusted_factors(u = 1.2, d = 0.8, lambda = 0.1, v_u = 1, v_d = 1)
}
