% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotABD.R
\name{plotABD}
\alias{plotABD}
\title{plotABD}
\usage{
plotABD(
  inTRW,
  min_nTrees_year = 3,
  pct_stdTRW_th = 0.5,
  pct_Trees_th = 0.3,
  linewidth_TRW = 0.7,
  linewidth_Ntrees = 1,
  byYears = 20,
  xlim = NULL,
  ylimABD = NULL,
  ...
)
}
\arguments{
\item{inTRW}{tibble. A tibble. The input dataset obtained from
the \code{TRW_readExcel()} function.}

\item{min_nTrees_year}{Numeric. The minimum number of trees per year required within each age class
to be included in the analysis.
The default is 3.
Using less than three trees may result in poor representation of within-class
variability and is not recommended unless data availability is limited.}

\item{pct_stdTRW_th}{Numeric. It defines the threshold for the minimum
proportion of standardized tree-ring width values required within a given
age class.
The default is set to 0.5,
meaning that at least 50\% of the possible
values must be present (e.g., 6 out of 10 values for 10-year age bands,
or 11 out of 20 for 20-year bands).
For instance, the final age band of a 94-year-old tree
(i.e., the 91–100-year band) includes only 4 years of growth.
Since this number of years below the threshold, we recommend
excluding that tree from the corresponding age band group.}

\item{pct_Trees_th}{Numeric. It defines the threshold used to calculate
the mean standardized tree-ring widths within each age band.
The default value is 0.3.
However, when working with small sample sizes (approximately 20 trees or fewer),
it is advisable to increase the threshold to 0.5.
This adjustment helps retain more trees in the analysis while still
accounting for natural growth variability.}

\item{linewidth_TRW}{numeric. line size for TRW.}

\item{linewidth_Ntrees}{numeric. line size for Ntrees.}

\item{byYears}{numeric. Spacing (in years) between tick marks on the x-axis of time-related plots.}

\item{xlim}{Optional numeric vector of length 2 specifying the limits of the x-axis.
If \code{NULL} the limits are automatically determined.}

\item{ylimABD}{Optional numeric vector of length 2 specifying the limits of the y-axis
for the ABD panel. If \code{NULL} the limits are automatically determined.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
None. A multipanel plot.
}
\description{
Function for plotting ABD values from \code{inTRW} object using the two \code{tibble} objects
produced by the function \code{TRW_readExcel}.
}
\details{
This function produces a multi-panel plot with three graphs:
the first displays standardized values by age band;
the second shows the final mean chronology (ABD), adjusted for age-related effects;
and the third depicts the corresponding number of trees.
}
\examples{

plotABD(inTRW, 
   min_nTrees_year = 3, 
   pct_stdTRW_th = .5,
   pct_Trees_th = .3,
   byYears = 50)
}
\seealso{
\code{\link{plotBAI}}, \code{\link{plotTRW}},  \code{\link{ABD}}

Other tree ring plotting: 
\code{\link{plotBAI}()},
\code{\link{plotTRW}()}
}
\concept{tree ring plotting}
