# cosCorr

## Overview

The **cosCorr** package implements the cosine-correlation coefficient, a novel measure 
for assessing the degree of linear dependence among variables in a multidimensional context.

## Installation

```r
install.packages("cosCorr")
```

## Usage

```r
library(cosCorr)

# Simple example
x <- c(0, 2, 3, 4)
rho <- cosCorr(x)
print(rho)
```

## Mathematical Foundation

The cosine-correlation coefficient is defined as:

rho = [(p-1) * prod(|t_i|)] / sum(|t_i|^(p-1))

where t_1 = 0 and t_2, ..., t_p are the variables in the system.

## Author

Mehmet Niyazi Cankaya

Faculty of Applied Sciences

Department of International Trading and Finance

Usak University, Usak, Turkey

Email: mehmet.cankaya@usak.edu.tr

## Reference

Cankaya, M. N. (2025). Derivatives through Probes in Regular Geometric Objects: 
A Dimensional Exploration for qqq-Sets in Time Scale Calculus. *Fractals*, 
in printing progress.

