## ----preliminary, echo=FALSE, out=FALSE---------------------------------------
library(knitr)
library(plgraphics) ##, lib="/u/stahel/R/regdevelop/pkg/plgraphics.Rcheck")

knitr::opts_chunk$set(fig.width=8, fig.height=6, fig.ext="pdf") 
olddigits <- options(digits=3)

## ----logstCurve, fig.width=8, fig.height=7.5----------------------------------
dd <- c(seq(0,1,0.1),5*10^rnorm(100,0,0.2))
dd <- sort(dd)
r.dl <- logst(dd)
attr(r.dl, "threshold")
cbind(data=dd, logst=r.dl, log10=log10(dd))[1:20,]
## logst and log10 coincide for data values
##   larger than the threshold 1.55
plot(dd, r.dl, type="l")
abline(v=attr(r.dl,"threshold"),lty=2)

plpoints(8,0.4, plab="log10", csize=2)
text(0.5,0.5, "linear", cex=2, srt=90)

## ----keepThreshold------------------------------------------------------------
##  example showing the effect of fixing the threshold
data(d.blast)

##  first 3 locations
dd <- d.blast[as.numeric(d.blast$location)<=3,]
y13 <- logst(dd$tremor)
plyx(y13~as.numeric(dd$location), data=dd,
  xlim=c(0,5), ylim=c(-0.2,NA), xlab="location", ylab="lg(tremor)")

## forth location
tremor4 <- d.blast$tremor[d.blast$location=="loc4"]

## transform tremor of location 4 alone
y4raw <- logst(tremor4)
plpoints(rep(4.3,47), y4raw, col="red")
abline(h=log10(attr(y4raw, "threshold")), lty=3, col="red")
## transform tremor of location 4 using threhold from locations 1-3
y4 <- logst(tremor4, threshold=attr(y13, "threshold"))
plpoints(rep(4,47), y4, col="blue")
abline(h=log10(attr(y13, "threshold")), lty=3, col="blue")

