% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero.R
\name{zero}
\alias{zero}
\title{Zero-Finding}
\usage{
zero(f, guesses, tol = 1e-07)
}
\arguments{
\item{f}{A function taking a numeric vector of length one.}

\item{guesses}{A numerical vector of length two giving two guesses for the
zero of the function.  The sign of the function evaluated at these two
guesses must be opposite.}

\item{tol}{Tolerance controlling the desired precision.}
}
\description{
This function demonstrates a Rust implementation of the zero-finding
algorithm shown in Section 5.11.1 "Zero-finding" of \href{https://cran.r-project.org/doc/manuals/R-exts.html#Zero_002dfinding}{\emph{Writing R Extensions}}
}
\examples{
cube1 <- function(x) (x^2 + 1) * (x - 1.5)
zero(cube1, c(-2, 11.5))
}
