## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  echo = TRUE,
  warning = FALSE,
  collapse = TRUE,
  comment = "#>"
)

## ----echo = FALSE, fig.cap = "Figure 1: Model object schema", out.width = "50%"----
knitr::include_graphics("ModelObjectFigure.png")

## ----echo = FALSE, fig.cap = "Figure 2: An example of an MCSim model specification", out.width = "50%"----
knitr::include_graphics("ModelSpecificationComponents.png")

## ----eval = FALSE-------------------------------------------------------------
# mod <- createModel(mString = mod_string)

## ----eval = FALSE-------------------------------------------------------------
# mod <- createModel(mName = "ex")

## ----eval = FALSE-------------------------------------------------------------
# mod <- createModel(mName = "/path/to/ex")

## ----eval = FALSE-------------------------------------------------------------
# mod$loadModel()

## ----echo = FALSE, fig.cap = "Figure 3: Files associated with an MCSim Model object", out.width = "50%"----
knitr::include_graphics("ModelFiles.png")

## ----eval = FALSE-------------------------------------------------------------
# out <- model$runModel(times)

## ----eval = FALSE-------------------------------------------------------------
# compileModel("ex.model", "ex_model.c", "ex_model", "ex_model.dll", "ex_model.md5")

