## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(gpyramid)
library(ape)
library(dplyr)

## -----------------------------------------------------------------------------
line_df <- data.frame(line = c("x1", "x2", "x3", "x4"),
                      gene1 = c("A", "B", "B", "B"),
                      gene2 = c("B", "A", "B", "B"),
                      gene3 = c("B", "B", "A", "B"),
                      gene4 = c("B", "B", "B", "A"))

line_df

## -----------------------------------------------------------------------------
position_df <- data.frame(Gene = c("g1", "g2", "g3", "g4"),
                          Chr = c("1A", "1A", "1A", "1A"),
                          cM = c(0, 20, 40, 60))
position_df

## -----------------------------------------------------------------------------
gene_dat <- util_haplo(line_df, target = "A", non_target = "B", hetero = "H", line_cul = "line")

gene_df1 <- gene_dat[[1]]
gene_df2 <- gene_dat[[2]]
line_id <- gene_dat[[3]]

colnames(gene_df1) <- line_id
colnames(gene_df2) <- line_id

gene_df1
gene_df2

## -----------------------------------------------------------------------------
recom_mat <- util_recom_mat(position_df, "cM")
recom_mat

## -----------------------------------------------------------------------------
line_comb_lis <- findPset(gene_df1, gene_df2, line_id)
line_comb_lis

## -----------------------------------------------------------------------------
rslt <- calcCostAll(line_comb_lis, gene_df1, gene_df2, recom_mat, 
                    prob_total = 0.99, last_cross = T, last_selfing = T)
rslt$cost_all

## ----fig.width=4, fig.height=4------------------------------------------------
rslt_one <- getFromAll(rslt, cross_id = 15)
summary(rslt_one)
plot(rslt_one$topolo)
nodelabels()

## ----fig.width=4, fig.height=4------------------------------------------------
rslt_one <- getFromAll(rslt, cross_id = 6)
summary(rslt_one)
plot(rslt_one$topolo)
nodelabels()

## ----fig.width=4, fig.height=4------------------------------------------------
rslt_one <- getFromAll(rslt, cross_id = 13)
summary(rslt_one)
plot(rslt_one$topolo)
nodelabels()

