'\"
'\" Generated from combobox.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "combobox" n 2.3 combobox ""
.BS
.SH NAME
combobox \- Combobox Megawidget
.SH "SYNOPSIS"
package require combobox 2.3 \fR
.sp
combobox::combobox \fIpathName\fR ?options? \fR
.sp
.BE
.SH "DESCRIPTION"
This package provides a new widget named "combobox" which combines an
entry widget and a dropdown menu into a single widget.
.SH "STANDARD OPTIONS"
-background
-borderwidth
-cursor
-font
-foreground
-height
-highlightthickness
-highlightbackground
-highlightcolor
-maxheight
-relief
-selectbackground
-selectborderwidth
-selectforeground
-state
-textvariable
-xscrollcommand
.PP
See the options manual entry for detailed descriptions of the above options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-buttonbackground\fR
Database Name:	\fBbuttonBackground\fR
Database Class:	\fBButtonBackground\fR
.fi
.IP
Defines the background color of the button used to activate the
dropdown list.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-command\fR
Database Name:	\fBcommand\fR
Database Class:	\fBCommand\fR
.fi
.IP
Defines a command to be run whenver the user selects a value from the
dropdown list box. If the combobox is editable, the command will also
be called whenever the user presses return or the widget loses the keyboard
focus and the value has changed. The command will have two values
appended to it: the name of the window and the new value of the
combobox. The value is considered to have changed if it differs from
the value when the entry first gained focus, or since the last time
the command was called.
.sp
It is important to note that if the combobox has an associated
\fI-textvariable\fR, the command will not be called if the value of
the variable is changed external to the combobox.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-commandstate\fR
Database Name:	\fBcommandState\fR
Database Class:	\fBState\fR
.fi
.IP
One of "normal" or "disabled". If set to "disabled", the value of
the B<-command> option will not be evaluated when the value of the
combobox changes.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-disabledbackground\fR
Database Name:	\fBdisabledBackground\fR
Database Class:	\fBDisabledBackground\fR
.fi
.IP
Defines the background color for the combobox when it is disabled.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-disabledforeground\fR
Database Name:	\fBdisabledForeground\fR
Database Class:	\fBDisabledForeground\fR
.fi
.IP
Defines the foreground color for the combobox when it is disabled.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-dropdownwidth\fR
Database Name:	\fBdropdownWidth\fR
Database Class:	\fBDropdownWidth\fR
.fi
.IP
Defines the width of the dropdown list. If null or 0, the dropdown
listbox width will be the same as the always-visible portion of the
combobox (ie: the entry and menubutton). Otherwise the value specifies
the number of average-sized characters to display in the dropdown listbox.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-editable\fR
Database Name:	\fBeditable\fR
Database Class:	\fBEditable\fR
.fi
.IP
.
A boolean value which specifies whether the entry widget of the
combobox can be typed in. If false, values may only be set by
selecting them from the dropdown list.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-elementborderwidth\fR
Database Name:	\fBelementBorderWidth\fR
Database Class:	\fBBorderWidth\fR
.fi
.IP
Specifies the width of borders drawn around the internal elements of
the widget (the button and the scrollbars for the dropdown list).
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-height\fR
Database Name:	\fBheight\fR
Database Class:	\fBHeight\fR
.fi
.IP
Specifies the hight of the dropdown list, in number of lines. A value
of zero will make the dropdown list just tall enough to hold all of
the elements in the list. The height defaults to 10.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-image\fR
Database Name:	\fBimage\fR
Database Class:	\fBImage\fR
.fi
.IP
Defines an image to use on the button used to drop down the list. If
it is not specified it defaults to a small black triangle.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-listvar\fR
Database Name:	\fBlistVariable\fR
Database Class:	\fBListVariable\fR
.fi
.IP
Specifies the name of a variable associated with the dropdown listbox.
If the variable changes the listbox will automatically update itself
to reflect the new value. Attempts to unset a variable in use as a
listvar will fail but will not generate an error.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-maxheight\fR
Database Name:	\fBmaxHeight\fR
Database Class:	\fBHeight\fR
.fi
.IP
Sets the maximum height of the dropdown list, in the event
B<-height> is set to zero and there are a large number of items in the
list. If this value is set to 0 (zero) the list will be as large as
the total number of items in the list. The maxheight defaults to 10.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-opencommand\fR
Database Name:	\fBopenCommand\fR
Database Class:	\fBCommand\fR
.fi
.IP
If this option is specified then it provides a Tcl command to
execute each time the combobox is opened (eg: when the dropdown
listbox is displayed). The command is invoked by the B<open> widget
command before opening the combobox.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-value\fR
Database Name:	\fBvalue\fR
Database Class:	\fBValue\fR
.fi
.IP
Specifies the value for the combobox.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-width\fR
Database Name:	\fBwidth\fR
Database Class:	\fBWidth\fR
.fi
.IP
Specifies an integer value indicating the desired width of the
combobox entry widget, in average size characters of the widget's
font. If the value is less than or equal to zero, the widget picks a
size large enough to hold its current text.
.SH "OVERVIEW"
The \fBcombobox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a dropdown combobox
widget. Additional options, described above, may be specified on the
command line. Currently no option database support is provided. The
\fBcombobox\fR command returns its \fIpathName\fR arguument. At
the time this command is invoked, there must not exists a window named
\fIpathName\fR, but \fIpathName's\fR parent must exist.
.PP
A combobox is a widget that displays a one-line text string, and
allows that string to be edited or selected from a dropdown list. When
first created a combobox's value is the null string unless a variable
is associated with the widget using the \fI-textvariable\fR option, in
which case it will be the value stored in the associated variable.
.PP
The combobox entry wiget is capable of displaying strings that are too
long to fit entirely within the widget's window. In this case only a
portion of the string will be displayed; commands described below may
be used to change the view in the window. Comboboxes use the standard
-xscrollcommand mechanism for interacting with scrollbars (see
the description of the -xscrollcommand option for
details). They also support scanning, as described below.
.SH "WIDGET COMMAND"
The \fBcombobox\fR command creates a new Tcl command whose name is
\fIpathName\fR. This command may be used to invoke various operations on
the widget. It has the following general form:
.nf
    \fIpathName\fR option ?arg arg ...?
.fi
\fIoption\fR and the \fIarg\fRs determine the exact behavior of the command.
.PP
Many of the widget commands take one or more indicies as
arguments. For \fBlist\fR commands the indicies may take one of the forms
acceptable to the standard listbox command. For all other commands
the indicies may take the form of an indicie for a standard entry
widget. See the appropriate man pages for more information.
.PP
The following commands are possible for combobox widgets:
.PP
.TP
\fIpathName\fR \fBbbox\fR \fIindex\fR
Returns a list of four numbers describing the bounding box of the
characters given by \fIindex\fR. The first two elements of the list give
the x and y coordinates of the upper-left corner of the screen area
covered by the character (in pixels relative to the widget) and the
last two elements give the width and height of the character, in
pixels. The bounding box may refer to a region outside the visible
area of the window.
.TP
\fIpathName\fR \fBcget\fR \fIoption\fR
Returns the current value for the configuration option give
by \fIoption\fR. \fIOption\fR may have any of the values accepted by
the \fBcombobox\fR command.
.TP
\fIpathName\fR \fBclose\fR
Causes the dropdown listbox of the widget to be withdrawn if it is
currently displayed.
.TP
\fIpathName\fR \fBconfigure\fR \fIoption\fR
Query or modify the configuration options of the widget. If no option
is specified, returns a list describing all of the available options
for pathName, though not in the same format as describe in
Tk_ConfigureInfo. The format will be a list, where each element will
be a list of two values: an option name and the current value.
.sp
If \fIoption\fR is specified with no value, then the command
returns a list describing the one named \fIoption\fR. This list will be
identical to the corresponding sublist of the value returned if no
\fIoption\fR is specified.  If one or more option-value pairs are
specified, then the command modifies the given widget \fIoption\fR(s) to
have the given value(s);  in this case the command returns an empty
string. \fIOption\fR may have any of the values accepted by the entry
command.
.TP
\fIpathName\fR \fBcurselection\fR
Returns the index of the dropdown list item that matches the value
of the combobox, or -1 if the combobox is editable and the string
doesn't match a value in the list.
.TP
\fIpathName\fR \fBdelete\fR \fIfirst\fR ?last?
Delete one or more elements from the combobox entry widget. \fIFirst\fR
is the index of the first character to delete, and \fIlast\fR is the index
of the character just after the last one to delete. If \fIlast\fR isn't
specified it defaults to \fIfirst\fR+1, i.e. a single character is
deleted. This command returns an empty string.
.TP
\fIpathName\fR \fBget\fR
Returns the combobox's string.
.TP
\fIpathName\fR \fBicursor\fR \fIindex\fR
Arrange for the insertion cursor to be displayed just before the
character given by \fIindex\fR. Returns an empty string.
.TP
\fIpathName\fR \fBindex\fR \fIindex\fR
Returns the numerical index corresponding to \fIindex\fR
.TP
\fIpathName\fR \fBinsert\fR \fIindex\fR \fIstring\fR
Insert the characters of \fIstring\fR just before the character indicated
by \fIindex\fR. Returns an empty string.
.TP
\fIpathName\fR \fBlist\fR \fIoption\fR \fIargs\fR
This command is used to manipulate the items in the dropdown
list. It has several forms, depending on \fIoption\fR:
.RS
.TP
\fBlist\fR \fBdelete\fR \fIfirst\fR ?last?
Deletes one or more elements of the dropdown list.  First and last are
indices specifying the first and last elements in the range to delete.
If last isn't specified it defaults to first, i.e. a single element is
deleted.
.TP
\fBlist\fR  \fBget\fR \fIfirst\fR ?last?
If last is omitted, returns the contents of the dropdown list element
indicated by first, or an empty string if first refers to a
non-existent element. If last is specified, the command returns a list
whose elements are all of the dropdown list elements between first and last,
inclusive. Both first and last may have any of the standard forms for
indices.
.TP
\fBlist\fR \fBindex\fR \fIindex\fR
Returns the integer index value that corresponds to index. If index is
end the return value is a count of the number of elements in the
dropdown list (not the index of the last element).
.TP
\fBlist\fR \fBinsert\fR \fIindex\fR  ?element element ...?
Inserts zero or more new elements in the list just before the element
given by index.  If index is specified as end then the new elements
are added to the end of the list.  Returns an empty string.
.TP
\fBlist\fR \fBsize\fR
Returns a decimal string indicating the total number of elements in
the dropdown list.  .sp
.RE
.TP
\fIpathName\fR \fBopen\fR
Causes the dropdown listbox of the combobox to be displayed if it
is currently hidden.
.TP
\fIpathName\fR \fBscan\fR \fIoption\fR \fIargs\fR
This command is used to implement scanning on the combobox entry
widget.  It has two forms, depending on option:
.RS
.TP
\fIpathName\fR \fBscan mark\fR \fIx\fR
Records x and the current view in the entry window;  used in
conjunction with later \fBscan dragto\fR commands.  Typically this
command is associated with a mouse button press in the widget.  It
returns an empty string.
.TP
\fIpathName\fR \fBscan dragto\fR \fIx\fR
This command computes the difference between its \fIx\fR argument
and the \fIx\fR argument to the last \fBscan mark\fR  command
for the widget.  It then adjusts the view left or right by 10 times
the difference in x-coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the entry at high speed through the window.  The return
value is an empty string.   .sp
.RE
.TP
\fIpathName\fR \fBselect\fR \fIindex\fR
Selects the item in the dropdown list represented by \fIindex\fR and
makes that the current value of the combobox.
.TP
\fIpathName\fR \fBselection\fR \fIoption\fR \fIarg\fR
This command is used to adjus the selection within the editable
portion of the combobox. It has several forms, depending on
\fIoption\fR:
.RS
.TP
\fIpathName\fR \fBselection\fR \fBadjust\fR \fIindex\fR
Locate the end of the selection nearest to the character given by
\fIidnex\fR (i.e. including but not going beyond \fIindex\fR). The
other end of the selection is made the anchor point for future
\fBselect to\fR commands. If the selection isn't currently in
the editable portion of the combobox, then a new selection is created
to include the characters between \fIindex\fR and the most recent
selection anchor point, inclusive. Returns an empty string.
.TP
\fIpathName\fR \fBselection\fR \fBclear\fR
Clear the selection if it is currently in this widget. If the
selection isn't in this widget then the command has no
effect. Returns an empty string.
.TP
\fIpathname\fR \fBselection\fR \fBfrom\fR \fIindex\fR
Set the selection anchor point to just before the character given by
\fIindex\fR. Doesn't change the selection. Returns an empty string.
.TP
\fIpathname\fR \fBselection\fR \fBparent\fR
Returns 1 if there are characters selected in the editable portion of
the combobox, otherwise it returns 0.
.TP
\fIpathname\fR \fBselection\fR \fBrange\fR \fIstart\fR \fIend\fR
Sets the selection to include the characters starting with the one
indexed by \fIstart\fR and ending with the one just before \fIend\fR.
If \fIend\fR refers to the same character as \fIstart\fR or an
earlier one, then the selection is cleared.
.TP
\fIpathname\fR \fBselection\fR \fBto\fR \fIindex\fR
If \fIindex\fR is before the anchor point, set the selection to the
characters from \fIindex\fR up to but not including the anchor
point. If \fIindex\fR is the same as the anchor point, do nothing. If
\fIindex\fR is after the anchor point, set the selection to the
characters from the anchor point up to but not including \fIindex\fR.
The anchor point is determined by the most recent \fBselect from\fR
or \fBselect adjust\fR command in this widget. If the selection
isn't in this widget then a new selection is created using the most
recent anchor point specified for the widget. Returns an empty string.
.sp
.RE
.TP
\fIpathName\fR \fBsubwidget\fR ?name?
This command returns a list of internal widget names if given no
arguments, or returns the internal widget path for the widget identified
by \fIname\fR.
.TP
\fIpathName\fR \fBxview\fR \fIargs\fR
This command is used to query and change the horizontal position of
the text in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName\fR \fBxview\fR
Returns a list containing two elements. Each element is a real
fraction between 0 and 1;  together they describe the horizontal span
that is visible in the window. For example, if the first element is .2
and the second element is .6, 20% of the entry's text is off-screen to
the left, the middle 40% is visible in the window, and 40% of the text
is off-screen to the right. These are the same values passed to
scrollbars via the \fI-xscrollcommand\fR option.
.TP
\fIpathName\fR \fBxview\fR \fIindex\fR
Adjusts the view in the window so that the character given by \fIindex\fR is
displayed at the left edge of the window.
.TP
\fIpathName\fR \fBxview\fR \fBmoveto\fR \fIfraction\fR
Adjusts the view in the window so that the character \fIfraction\fR of the
way through the text appears at the left edge of the window. \fIFraction\fR
must be a fraction between 0 and 1.
.TP
\fIpathName\fR \fBxview\fR \fBscroll\fR \fInumber\fR
\fIwhat\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR. \fINumber\fR must be an integer.
\fIWhat\fR must be
either units or pages or an abbreviation of one of these. If \fIwhat\fR
is units, the view adjusts left or right by number average-width
characters on the display;  if it is pages then the view adjusts by
number screenfuls. If \fInumber\fR is negative then characters farther to
the left become visible;  if it is positive then characters farther to
the right become visible.
.RE
.SH " DEFAULT BINDINGS"
Bindings in the entry widget of the combobox are the same as for
normal entry widgets, with the following exceptions:
.PP
Double-clicking mouse button 1 over the entry widget will display the
dropdown list if it is not displayed, and hide it if it is. The value
of the combobox won't change.
.PP
If \fI-editable\fR is set to false, single-clicking mouse button 1
over the entry widget will display the dropdown list if it is not
displayed, and hide it if it is. The value of the combobox won't change.
.PP
Pressing the Up, Down, Next and Prior buttons (up arrow, down arrow,
page up and page down, respectively) will display the dropdown list if
it is not displayed. If it is displayed, these buttons will change the
current selection on the list.
.PP
If \fI-editable\fR is true, pressing the Return or Tab key will set the
value to the string in the entry widget. If the list is
displayed and an item is selected, Return will set the value of the
combobox to the selected item.
.PP
If \fI-editable\fR is false, pressing the Return key when the list is
displayed will result in the value of the combobox changing to the
currently highlighted item in the list. The list will be closed.
.PP
Pressing the escape key when the list is displayed will result in the
list being closed with the value of the combobox remaining unchanged.
.PP
Clicking the mouse button over an element in the dropdown list will
cause the clicked-on item to be the new value of the combobox, and the
list will be closed.
.PP
If the combobox is disabled using the \fI-state\fR option, then the entry
widget's view can still be adjusted and text in the entry can be
selected, but no insertion cursor will be displayed, no text
modification will be possible, and the list cannot be displayed.
.SH "BUGS"
With some window managers it may be possible to move the window that
contains the combobox while the dropdown list is visible. In such a
case the dropdown list will stay where it originally appeared. Well
behaved window managers shouldn't let you move the window while the
list is displayed.
.PP
It has been reported that with some virtual window managers, switching
to a new virtual window while the dropdown list is visible will result
in the dropdown list appearing by itself in the new virtual window.
.PP
So the lesson here is: don't dork with your windows while the dropdown
list is visible. That, or get a better window manager.
