## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center"
)
set.seed(0)
library(dplyr)
library(multidplyr)
library(skytrackr)
library(ggplot2)

## ----out.width="85%", fig.width = 10, fig.height = 5--------------------------
# an overview profile
cc876 |> stk_profile()

## ----out.width="85%", fig.width = 10, fig.height = 5--------------------------
# an overview profile
cc876 |> stk_filter(range = c(0.09, 400), plot = TRUE)

## ----out.width="85%", fig.width = 10, fig.height = 4--------------------------
# calculate the attenuation Beer-Lambert for LAI
lai_range <- seq(0, 10, by = 0.1)
lai_att <- 100 - (exp(-0.5 * lai_range) * 100)

# set the range of scale factors
scale_factor <- seq(1, 2000, by = 1)

# calculate "sky condition" based attenuation values
sky_att <- lapply(scale_factor, function(i){
  ideal <- skylight::skylight(
    date = as.POSIXct("2022-01-01 12:00:00"),
    latitude = 0,
    longitude = 0,
    sky_condition = 3
  )$sun_illuminance

  c <- skylight::skylight(
    date = as.POSIXct("2022-01-01 12:00:00"),
    latitude = 0,
    longitude = 0,
    sky_condition = i
  )$sun_illuminance / ideal

  c <- c * 100
  c <- ifelse(c > 100, NA, c)
  c <- 100 - c
}) |> unlist()

  lai_scale_factor <- lapply(lai_att, function(a){
    scale_factor[which.min(abs(sky_att - a))]
  }) |> unlist()

ggplot2::ggplot() +
  ggplot2::geom_line(
    aes(
    lai_range,
    lai_scale_factor
    )
  ) +
  ggplot2::labs(
    title = "LAI ~ scale factors",
    x = "LAI",
    y = "scale factor"
  ) +
  ggplot2::theme_minimal()

## ----label = "final-plot", echo = FALSE, fig.cap="Overview plot after location estimation"----
knitr::include_graphics("poor_fit.png")

