#line 16 "preprocessor.l"
// GENERATED FILE - DO NOT EDIT.
// Generated by generate_parser.py from preprocessor.l
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// preprocessor.l:
//   Lexer for the OpenGL shading language preprocessor.

#ifdef UNSAFE_BUFFERS_BUILD
#    pragma allow_unsafe_buffers
#endif

#define YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#    define FLEX_BETA
#endif

#ifdef yy_create_buffer
#    define pp_create_buffer_ALREADY_DEFINED
#else
#    define yy_create_buffer pp_create_buffer
#endif

#ifdef yy_delete_buffer
#    define pp_delete_buffer_ALREADY_DEFINED
#else
#    define yy_delete_buffer pp_delete_buffer
#endif

#ifdef yy_scan_buffer
#    define pp_scan_buffer_ALREADY_DEFINED
#else
#    define yy_scan_buffer pp_scan_buffer
#endif

#ifdef yy_scan_string
#    define pp_scan_string_ALREADY_DEFINED
#else
#    define yy_scan_string pp_scan_string
#endif

#ifdef yy_scan_bytes
#    define pp_scan_bytes_ALREADY_DEFINED
#else
#    define yy_scan_bytes pp_scan_bytes
#endif

#ifdef yy_init_buffer
#    define pp_init_buffer_ALREADY_DEFINED
#else
#    define yy_init_buffer pp_init_buffer
#endif

#ifdef yy_flush_buffer
#    define pp_flush_buffer_ALREADY_DEFINED
#else
#    define yy_flush_buffer pp_flush_buffer
#endif

#ifdef yy_load_buffer_state
#    define pp_load_buffer_state_ALREADY_DEFINED
#else
#    define yy_load_buffer_state pp_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#    define pp_switch_to_buffer_ALREADY_DEFINED
#else
#    define yy_switch_to_buffer pp_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#    define pppush_buffer_state_ALREADY_DEFINED
#else
#    define yypush_buffer_state pppush_buffer_state
#endif

#ifdef yypop_buffer_state
#    define pppop_buffer_state_ALREADY_DEFINED
#else
#    define yypop_buffer_state pppop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#    define ppensure_buffer_stack_ALREADY_DEFINED
#else
#    define yyensure_buffer_stack ppensure_buffer_stack
#endif

#ifdef yylex
#    define pplex_ALREADY_DEFINED
#else
#    define yylex pplex
#endif

#ifdef yyrestart
#    define pprestart_ALREADY_DEFINED
#else
#    define yyrestart pprestart
#endif

#ifdef yylex_init
#    define pplex_init_ALREADY_DEFINED
#else
#    define yylex_init pplex_init
#endif

#ifdef yylex_init_extra
#    define pplex_init_extra_ALREADY_DEFINED
#else
#    define yylex_init_extra pplex_init_extra
#endif

#ifdef yylex_destroy
#    define pplex_destroy_ALREADY_DEFINED
#else
#    define yylex_destroy pplex_destroy
#endif

#ifdef yyget_debug
#    define ppget_debug_ALREADY_DEFINED
#else
#    define yyget_debug ppget_debug
#endif

#ifdef yyset_debug
#    define ppset_debug_ALREADY_DEFINED
#else
#    define yyset_debug ppset_debug
#endif

#ifdef yyget_extra
#    define ppget_extra_ALREADY_DEFINED
#else
#    define yyget_extra ppget_extra
#endif

#ifdef yyset_extra
#    define ppset_extra_ALREADY_DEFINED
#else
#    define yyset_extra ppset_extra
#endif

#ifdef yyget_in
#    define ppget_in_ALREADY_DEFINED
#else
#    define yyget_in ppget_in
#endif

#ifdef yyset_in
#    define ppset_in_ALREADY_DEFINED
#else
#    define yyset_in ppset_in
#endif

#ifdef yyget_out
#    define ppget_out_ALREADY_DEFINED
#else
#    define yyget_out ppget_out
#endif

#ifdef yyset_out
#    define ppset_out_ALREADY_DEFINED
#else
#    define yyset_out ppset_out
#endif

#ifdef yyget_leng
#    define ppget_leng_ALREADY_DEFINED
#else
#    define yyget_leng ppget_leng
#endif

#ifdef yyget_text
#    define ppget_text_ALREADY_DEFINED
#else
#    define yyget_text ppget_text
#endif

#ifdef yyget_lineno
#    define ppget_lineno_ALREADY_DEFINED
#else
#    define yyget_lineno ppget_lineno
#endif

#ifdef yyset_lineno
#    define ppset_lineno_ALREADY_DEFINED
#else
#    define yyset_lineno ppset_lineno
#endif

#ifdef yyget_column
#    define ppget_column_ALREADY_DEFINED
#else
#    define yyget_column ppget_column
#endif

#ifdef yyset_column
#    define ppset_column_ALREADY_DEFINED
#else
#    define yyset_column ppset_column
#endif

#ifdef yywrap
#    define ppwrap_ALREADY_DEFINED
#else
#    define yywrap ppwrap
#endif

#ifdef yyget_lval
#    define ppget_lval_ALREADY_DEFINED
#else
#    define yyget_lval ppget_lval
#endif

#ifdef yyset_lval
#    define ppset_lval_ALREADY_DEFINED
#else
#    define yyset_lval ppset_lval
#endif

#ifdef yyget_lloc
#    define ppget_lloc_ALREADY_DEFINED
#else
#    define yyget_lloc ppget_lloc
#endif

#ifdef yyset_lloc
#    define ppset_lloc_ALREADY_DEFINED
#else
#    define yyset_lloc ppset_lloc
#endif

#ifdef yyalloc
#    define ppalloc_ALREADY_DEFINED
#else
#    define yyalloc ppalloc
#endif

#ifdef yyrealloc
#    define pprealloc_ALREADY_DEFINED
#else
#    define yyrealloc pprealloc
#endif

#ifdef yyfree
#    define ppfree_ALREADY_DEFINED
#else
#    define yyfree ppfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#    define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#    if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types.
 */
#        ifndef __STDC_LIMIT_MACROS
#            define __STDC_LIMIT_MACROS 1
#        endif

#        include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#    else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#        ifndef INT8_MIN
#            define INT8_MIN (-128)
#        endif
#        ifndef INT16_MIN
#            define INT16_MIN (-32767 - 1)
#        endif
#        ifndef INT32_MIN
#            define INT32_MIN (-2147483647 - 1)
#        endif
#        ifndef INT8_MAX
#            define INT8_MAX (127)
#        endif
#        ifndef INT16_MAX
#            define INT16_MAX (32767)
#        endif
#        ifndef INT32_MAX
#            define INT32_MAX (2147483647)
#        endif
#        ifndef UINT8_MAX
#            define UINT8_MAX (255U)
#        endif
#        ifndef UINT16_MAX
#            define UINT16_MAX (65535U)
#        endif
#        ifndef UINT32_MAX
#            define UINT32_MAX (4294967295U)
#        endif

#        ifndef SIZE_MAX
#            define SIZE_MAX (~(size_t)0)
#        endif

#    endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#    define yynoreturn __attribute__((__noreturn__))
#else
#    define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR)(c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#    define YY_TYPEDEF_YY_SCANNER_T
typedef void *yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin, yyscanner)
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#    ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#        define YY_BUF_SIZE 32768
#    else
#        define YY_BUF_SIZE 16384
#    endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#    define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#    define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

#define YY_LESS_LINENO(n)
#define YY_LINENO_REWIND_TO(ptr)

/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n)                                                         \
    do                                                                    \
    {                                                                     \
        /* Undo effects of setting up yytext. */                          \
        int yyless_macro_arg = (n);                                       \
        YY_LESS_LINENO(yyless_macro_arg);                                 \
        *yy_cp = yyg->yy_hold_char;                                       \
        YY_RESTORE_YY_MORE_OFFSET                                         \
        yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
        YY_DO_BEFORE_ACTION; /* set up yytext again */                    \
    } while (0)
#define unput(c) yyunput(c, yyg->yytext_ptr, yyscanner)

#ifndef YY_STRUCT_YY_BUFFER_STATE
#    define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
{
    FILE *yy_input_file;

    char *yy_ch_buf;  /* input buffer */
    char *yy_buf_pos; /* current position in input buffer */

    /* Size of input buffer in bytes, not including room for EOB
     * characters.
     */
    int yy_buf_size;

    /* Number of characters read into yy_ch_buf, not including EOB
     * characters.
     */
    int yy_n_chars;

    /* Whether we "own" the buffer - i.e., we know we created it,
     * and can realloc() it to grow it, and should free() it to
     * delete it.
     */
    int yy_is_our_buffer;

    /* Whether this is an "interactive" input source; if so, and
     * if we're using stdio for input, then we want to use getc()
     * instead of fread(), to make sure we stop fetching input after
     * each newline.
     */
    int yy_is_interactive;

    /* Whether we're considered to be at the beginning of a line.
     * If so, '^' rules will be active on the next match, otherwise
     * not.
     */
    int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

    /* Whether to try to fill the input buffer when we reach the
     * end of it.
     */
    int yy_fill_buffer;

    int yy_buffer_status;

#    define YY_BUFFER_NEW 0
#    define YY_BUFFER_NORMAL 1
    /* When an EOF's been seen but there's still some text to process
     * then we mark the buffer as YY_EOF_PENDING, to indicate that we
     * shouldn't try reading from the input source any more.  We might
     * still have a bunch of tokens to match, though, because of
     * possible backing-up.
     *
     * When we actually see the EOF, we change the status to "new"
     * (via yyrestart()), so that the user can continue scanning by
     * just pointing yyin at a new input file.
     */
#    define YY_BUFFER_EOF_PENDING 2
};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER \
    (yyg->yy_buffer_stack ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart(FILE *input_file, yyscan_t yyscanner);
void yy_switch_to_buffer(YY_BUFFER_STATE new_buffer, yyscan_t yyscanner);
YY_BUFFER_STATE yy_create_buffer(FILE *file, int size, yyscan_t yyscanner);
void yy_delete_buffer(YY_BUFFER_STATE b, yyscan_t yyscanner);
void yy_flush_buffer(YY_BUFFER_STATE b, yyscan_t yyscanner);
void yypush_buffer_state(YY_BUFFER_STATE new_buffer, yyscan_t yyscanner);
void yypop_buffer_state(yyscan_t yyscanner);

static void yyensure_buffer_stack(yyscan_t yyscanner);
static void yy_load_buffer_state(yyscan_t yyscanner);
static void yy_init_buffer(YY_BUFFER_STATE b, FILE *file, yyscan_t yyscanner);
#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER, yyscanner)

YY_BUFFER_STATE yy_scan_buffer(char *base, yy_size_t size, yyscan_t yyscanner);
YY_BUFFER_STATE yy_scan_string(const char *yy_str, yyscan_t yyscanner);
YY_BUFFER_STATE yy_scan_bytes(const char *bytes, int len, yyscan_t yyscanner);

void *yyalloc(yy_size_t, yyscan_t yyscanner);
void *yyrealloc(void *, yy_size_t, yyscan_t yyscanner);
void yyfree(void *, yyscan_t yyscanner);

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive)                                             \
    {                                                                                  \
        if (!YY_CURRENT_BUFFER)                                                        \
        {                                                                              \
            yyensure_buffer_stack(yyscanner);                                          \
            YY_CURRENT_BUFFER_LVALUE = yy_create_buffer(yyin, YY_BUF_SIZE, yyscanner); \
        }                                                                              \
        YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive;                  \
    }
#define yy_set_bol(at_bol)                                                             \
    {                                                                                  \
        if (!YY_CURRENT_BUFFER)                                                        \
        {                                                                              \
            yyensure_buffer_stack(yyscanner);                                          \
            YY_CURRENT_BUFFER_LVALUE = yy_create_buffer(yyin, YY_BUF_SIZE, yyscanner); \
        }                                                                              \
        YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol;                                  \
    }
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define ppwrap(yyscanner) (/*CONSTCOND*/ 1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state(yyscan_t yyscanner);
static yy_state_type yy_try_NUL_trans(yy_state_type current_state, yyscan_t yyscanner);
static int yy_get_next_buffer(yyscan_t yyscanner);
static void yynoreturn yy_fatal_error(const char *msg, yyscan_t yyscanner);

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION                   \
    yyg->yytext_ptr   = yy_bp;                \
    yyleng            = (int)(yy_cp - yy_bp); \
    yyg->yy_hold_char = *yy_cp;               \
    *yy_cp            = '\0';                 \
    yyg->yy_c_buf_p   = yy_cp;
#define YY_NUM_RULES 37
#define YY_END_OF_BUFFER 38
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
{
    flex_int32_t yy_verify;
    flex_int32_t yy_nxt;
};
static const flex_int16_t yy_accept[95] = {
    0,  0,  0,  0,  0,  38, 36, 34, 35, 35, 33, 7,  33, 33, 33, 33, 33, 33, 33, 33, 9, 9,  33, 33,
    33, 8,  33, 33, 3,  5,  5,  4,  34, 35, 19, 27, 20, 30, 25, 12, 23, 13, 24, 10, 2, 1,  26, 10,
    9,  11, 11, 11, 9,  11, 9,  9,  14, 16, 18, 17, 15, 8,  31, 21, 32, 22, 3,  5,  6, 11, 10, 11,
    10, 1,  10, 11, 10, 0,  10, 9,  9,  9,  28, 29, 0,  10, 10, 10, 10, 9,  10, 10, 9, 10, 0

};

static const YY_CHAR yy_ec[256] = {
    0,  1,  1,  1,  1,  1,  1,  1,  1,  2,  3,  2,  2,  4,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  5,  1,  6,  1,  7,  8,  1,  9,  9,
    10, 11, 9,  12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 17, 17, 9,  9,  18, 19, 20,
    9,  1,  21, 21, 21, 21, 22, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 25, 24, 24, 26, 24, 24, 9,  1,  9,  27, 24, 1,  21, 21, 21, 21,

    22, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 24, 24, 26, 24,
    24, 9,  28, 9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,

    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1};

static const YY_CHAR yy_meta[29] = {0, 1, 1, 2, 2, 1, 1, 1, 1, 1, 3, 1, 1, 4, 1,
                                    5, 5, 5, 1, 1, 1, 5, 5, 5, 5, 5, 5, 1, 1};

static const flex_int16_t yy_base[100] = {
    0,   0,   0,   26,  28,  133, 195, 130, 195, 128, 105, 195, 104, 25,  195, 100, 23,
    27,  32,  31,  38,  50,  38,  93,  49,  0,   16,  51,  0,   195, 105, 87,  93,  195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 67,  195, 0,   195, 81,  55,  84,  98,
    110, 53,  61,  0,   52,  39,  195, 195, 195, 33,  0,   195, 195, 195, 195, 0,   195,
    195, 113, 0,   126, 0,   0,   0,   133, 0,   56,  128, 0,   133, 0,   195, 195, 101,
    141, 143, 145, 0,   15,  154, 195, 0,   195, 195, 177, 32,  182, 187, 189

};

static const flex_int16_t yy_def[100] = {
    0,  94, 1,  95, 95, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
    20, 94, 94, 94, 96, 94, 94, 97, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
    94, 94, 94, 98, 94, 94, 20, 20, 49, 50, 50, 99, 21, 50, 94, 94, 94, 94, 94, 96, 94,
    94, 94, 94, 97, 94, 94, 43, 43, 69, 69, 98, 47, 50, 50, 94, 51, 50, 99, 50, 94, 94,
    94, 71, 75, 94, 50, 50, 94, 94, 50, 94, 0,  94, 94, 94, 94, 94

};

static const flex_int16_t yy_nxt[224] = {
    0,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 25, 25,
    25, 25, 25, 25, 26, 27, 29, 30, 29, 30, 36, 39, 62, 31, 61, 31, 41, 92, 44, 40, 63, 37, 45,
    42, 43, 43, 43, 46, 47, 83, 48, 48, 49, 56, 57, 82, 50, 51, 50, 50, 52, 53, 54, 54, 54, 59,
    60, 64, 87, 87, 87, 50, 55, 50, 81, 79, 65, 69, 50, 70, 70, 70, 50, 50, 50, 69, 71, 72, 69,
    69, 69, 50, 32, 74, 74, 74, 49, 49,

    68, 50, 75, 76, 50, 50, 50, 67, 50, 50, 50, 58, 50, 50, 50, 90, 90, 90, 38, 50, 77, 77, 35,
    34, 78, 78, 78, 69, 69, 69, 33, 32, 94, 94, 69, 69, 84, 84, 94, 94, 85, 85, 85, 84, 84, 50,
    94, 86, 86, 86, 88, 94, 94, 94, 94, 94, 50, 89, 50, 87, 87, 87, 94, 72, 94, 76, 94, 91, 90,
    90, 90, 94, 94, 94, 94, 94, 93, 28, 28, 28, 28, 28, 66, 94, 94, 66, 66, 73, 94, 73, 73, 73,
    80, 80, 5,  94, 94, 94, 94, 94,

    94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94};

static const flex_int16_t yy_chk[224] = {
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  3,  3,  4,  4,  13, 16, 26, 3,  96, 4,  17, 89, 19, 16, 26, 13, 19,
    17, 18, 18, 18, 19, 20, 60, 20, 20, 20, 22, 22, 56, 20, 20, 20, 20, 20, 20, 21, 21, 21, 24,
    24, 27, 77, 77, 77, 53, 21, 21, 55, 52, 27, 43, 48, 43, 43, 43, 53, 53, 53, 43, 43, 43, 43,
    43, 43, 47, 32, 47, 47, 47, 49, 49,

    31, 47, 47, 47, 47, 47, 47, 30, 49, 49, 50, 23, 50, 50, 50, 84, 84, 84, 15, 50, 51, 51, 12,
    10, 51, 51, 51, 69, 69, 69, 9,  7,  5,  0,  69, 69, 71, 71, 78, 78, 71, 71, 71, 75, 75, 80,
    0,  75, 75, 75, 78, 85, 85, 86, 86, 0,  80, 80, 80, 87, 87, 87, 0,  85, 0,  86, 0,  87, 90,
    90, 90, 0,  0,  0,  0,  0,  90, 95, 95, 95, 95, 95, 97, 0,  0,  97, 97, 98, 0,  98, 98, 98,
    99, 99, 94, 94, 94, 94, 94, 94,

    94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94};

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
/*
//
// Copyright 2002 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

This file contains the Lex specification for GLSL ES preprocessor.
Based on Microsoft Visual Studio 2010 Preprocessor Grammar:
http://msdn.microsoft.com/en-us/library/2scxys89.aspx

IF YOU MODIFY THIS FILE YOU ALSO NEED TO RUN scripts/run_code_generation.py
*/

#if defined(_MSC_VER)
#    pragma warning(disable : 4005)
#endif

#include "compiler/preprocessor/Tokenizer.h"

#include "compiler/preprocessor/DiagnosticsBase.h"
#include "compiler/preprocessor/Token.h"

#if defined(__GNUC__)
// Triggered by the auto-generated yy_fatal_error function.
#    pragma GCC diagnostic ignored "-Wmissing-noreturn"
#elif defined(_MSC_VER)
#    pragma warning(disable : 4244)
#endif
#if defined(__clang__)
// Flex uses `/*FALLTHROUGH*/` instead of dedicated statements.
#    pragma clang diagnostic ignored "-Wimplicit-fallthrough"
#    if defined(__APPLE__)
// Older clang versions don't have -Wextra-semi-stmt, and detecting Apple clang versions is
// difficult because they use different yet overlapping version numbers vs. regular clang.
#        pragma clang diagnostic ignored "-Wunknown-warning-option"
#    endif
// Flex isn't semi-colon clean.
#    pragma clang diagnostic ignored "-Wextra-semi-stmt"
#    pragma clang diagnostic ignored "-Wunreachable-code"
#endif

// Workaround for flex using the register keyword, deprecated in C++11.
#ifdef __cplusplus
#    if __cplusplus > 199711L
#        define register
#    endif
#endif

typedef std::string YYSTYPE;
typedef angle::pp::SourceLocation YYLTYPE;

// Use the unused yycolumn variable to track file (string) number.
#define yyfileno yycolumn

#define YY_USER_INIT                   \
    do                                 \
    {                                  \
        yyfileno              = 0;     \
        yylineno              = 1;     \
        yyextra->leadingSpace = false; \
        yyextra->lineStart    = true;  \
    } while (0);

#define YY_NO_INPUT
#define YY_USER_ACTION                                              \
    do                                                              \
    {                                                               \
        angle::pp::Input *input             = &yyextra->input;      \
        angle::pp::Input::Location *scanLoc = &yyextra->scanLoc;    \
        while ((scanLoc->sIndex < input->count()) &&                \
               (scanLoc->cIndex >= input->length(scanLoc->sIndex))) \
        {                                                           \
            scanLoc->cIndex -= input->length(scanLoc->sIndex++);    \
            ++yyfileno;                                             \
            yylineno = 1;                                           \
        }                                                           \
        yylloc->file = yyfileno;                                    \
        yylloc->line = yylineno;                                    \
        scanLoc->cIndex += yyleng;                                  \
    } while (0);

#define YY_INPUT(buf, result, maxSize) result = yyextra->input.read(buf, maxSize, &yylineno);

#define INITIAL 0
#define COMMENT 1

#define YY_EXTRA_TYPE angle::pp::Tokenizer::Context *

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
{

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top;       /**< index of top of stack. */
    size_t yy_buffer_stack_max;       /**< capacity of stack. */
    YY_BUFFER_STATE *yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char *yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE *yylval_r;

    YYLTYPE *yylloc_r;

}; /* end struct yyguts_t */

static int yy_init_globals(yyscan_t yyscanner);

/* This must go here because YYSTYPE and YYLTYPE are included
 * from bison output in section 1.*/
#define yylval yyg->yylval_r

#define yylloc yyg->yylloc_r

int yylex_init(yyscan_t *scanner);

int yylex_init_extra(YY_EXTRA_TYPE user_defined, yyscan_t *scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy(yyscan_t yyscanner);

int yyget_debug(yyscan_t yyscanner);

void yyset_debug(int debug_flag, yyscan_t yyscanner);

YY_EXTRA_TYPE yyget_extra(yyscan_t yyscanner);

void yyset_extra(YY_EXTRA_TYPE user_defined, yyscan_t yyscanner);

FILE *yyget_in(yyscan_t yyscanner);

void yyset_in(FILE *_in_str, yyscan_t yyscanner);

FILE *yyget_out(yyscan_t yyscanner);

void yyset_out(FILE *_out_str, yyscan_t yyscanner);

int yyget_leng(yyscan_t yyscanner);

char *yyget_text(yyscan_t yyscanner);

int yyget_lineno(yyscan_t yyscanner);

void yyset_lineno(int _line_number, yyscan_t yyscanner);

int yyget_column(yyscan_t yyscanner);

void yyset_column(int _column_no, yyscan_t yyscanner);

YYSTYPE *yyget_lval(yyscan_t yyscanner);

void yyset_lval(YYSTYPE *yylval_param, yyscan_t yyscanner);

YYLTYPE *yyget_lloc(yyscan_t yyscanner);

void yyset_lloc(YYLTYPE *yylloc_param, yyscan_t yyscanner);

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#    ifdef __cplusplus
extern "C" int yywrap(yyscan_t yyscanner);
#    else
extern int yywrap(yyscan_t yyscanner);
#    endif
#endif

#ifndef YY_NO_UNPUT

#endif

#ifndef yytext_ptr
static void yy_flex_strncpy(char *, const char *, int, yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen(const char *, yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#    ifdef __cplusplus
static int yyinput(yyscan_t yyscanner);
#    else
static int input(yyscan_t yyscanner);
#    endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#    ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#        define YY_READ_BUF_SIZE 16384
#    else
#        define YY_READ_BUF_SIZE 8192
#    endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#    define ECHO                                          \
        do                                                \
        {                                                 \
            if (fwrite(yytext, (size_t)yyleng, 1, yyout)) \
            {                                             \
            }                                             \
        } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#    define YY_INPUT(buf, result, max_size)                                                       \
        if (YY_CURRENT_BUFFER_LVALUE->yy_is_interactive)                                          \
        {                                                                                         \
            int c = '*';                                                                          \
            int n;                                                                                \
            for (n = 0; n < max_size && (c = getc(yyin)) != EOF && c != '\n'; ++n)                \
                buf[n] = (char)c;                                                                 \
            if (c == '\n')                                                                        \
                buf[n++] = (char)c;                                                               \
            if (c == EOF && ferror(yyin))                                                         \
                YY_FATAL_ERROR("input in flex scanner failed");                                   \
            result = n;                                                                           \
        }                                                                                         \
        else                                                                                      \
        {                                                                                         \
            errno = 0;                                                                            \
            while ((result = (int)fread(buf, 1, (yy_size_t)max_size, yyin)) == 0 && ferror(yyin)) \
            {                                                                                     \
                if (errno != EINTR)                                                               \
                {                                                                                 \
                    YY_FATAL_ERROR("input in flex scanner failed");                               \
                    break;                                                                        \
                }                                                                                 \
                errno = 0;                                                                        \
                clearerr(yyin);                                                                   \
            }                                                                                     \
        }

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#    define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#    define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#    define YY_FATAL_ERROR(msg) yy_fatal_error(msg, yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#    define YY_DECL_IS_OURS 1

extern int yylex(YYSTYPE *yylval_param, YYLTYPE *yylloc_param, yyscan_t yyscanner);

#    define YY_DECL int yylex(YYSTYPE *yylval_param, YYLTYPE *yylloc_param, yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#    define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#    define YY_BREAK /*LINTED*/ break;
#endif

#define YY_RULE_SETUP YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
    yy_state_type yy_current_state;
    char *yy_cp, *yy_bp;
    int yy_act;
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

    if (!yyg->yy_init)
    {
        yyg->yy_init = 1;

#ifdef YY_USER_INIT
        YY_USER_INIT;
#endif

        if (!yyg->yy_start)
        {
            yyg->yy_start = 1; /* first start state */
        }

        if (!yyin)
        {
            yyin = stdin;
        }

        if (!yyout)
        {
            yyout = stdout;
        }

        if (!YY_CURRENT_BUFFER)
        {
            yyensure_buffer_stack(yyscanner);
            YY_CURRENT_BUFFER_LVALUE = yy_create_buffer(yyin, YY_BUF_SIZE, yyscanner);
        }

        yy_load_buffer_state(yyscanner);
    }

    {

        /* Line comment */

        while (/*CONSTCOND*/ 1) /* loops until end-of-file is reached */
        {
            yy_cp = yyg->yy_c_buf_p;

            /* Support of yytext. */
            *yy_cp = yyg->yy_hold_char;

            /* yy_bp points to the position in yy_ch_buf of the start of
             * the current run.
             */
            yy_bp = yy_cp;

            yy_current_state = yyg->yy_start;
        yy_match:
            do
            {
                YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
                if (yy_accept[yy_current_state])
                {
                    yyg->yy_last_accepting_state = yy_current_state;
                    yyg->yy_last_accepting_cpos  = yy_cp;
                }
                while (yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state)
                {
                    yy_current_state = (int)yy_def[yy_current_state];
                    if (yy_current_state >= 95)
                    {
                        yy_c = yy_meta[yy_c];
                    }
                }
                yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
                ++yy_cp;
            } while (yy_current_state != 94);
            yy_cp            = yyg->yy_last_accepting_cpos;
            yy_current_state = yyg->yy_last_accepting_state;

        yy_find_action:
            yy_act = yy_accept[yy_current_state];

            YY_DO_BEFORE_ACTION;

        do_action: /* This label is used only to access EOF actions. */

            switch (yy_act)
            {           /* beginning of action switch */
                case 0: /* must back up */
                    /* undo the effects of YY_DO_BEFORE_ACTION */
                    *yy_cp           = yyg->yy_hold_char;
                    yy_cp            = yyg->yy_last_accepting_cpos;
                    yy_current_state = yyg->yy_last_accepting_state;
                    goto yy_find_action;

                case 1:
                    YY_RULE_SETUP

                    YY_BREAK
                /* Block comment */
                /* Line breaks are just counted - not returned. */
                /* The comment is replaced by a single space. */
                case 2:
                    YY_RULE_SETUP
                    {
                        BEGIN(COMMENT);
                    }
                    YY_BREAK
                case 3:
                    YY_RULE_SETUP

                    YY_BREAK
                case 4:
                    YY_RULE_SETUP

                    YY_BREAK
                case 5:
                    /* rule 5 can match eol */
                    YY_RULE_SETUP
                    {
                        if (yylineno == INT_MAX)
                        {
                            *yylval = "Integer overflow on line number";
                            return angle::pp::Token::GOT_ERROR;
                        }
                        ++yylineno;
                    }
                    YY_BREAK
                case 6:
                    YY_RULE_SETUP
                    {
                        yyextra->leadingSpace = true;
                        BEGIN(INITIAL);
                    }
                    YY_BREAK
                case 7:
                    YY_RULE_SETUP
                    {
                        // # is only valid at start of line for preprocessor directives.
                        yylval->assign(1, yytext[0]);
                        return yyextra->lineStart ? angle::pp::Token::PP_HASH
                                                  : angle::pp::Token::PP_OTHER;
                    }
                    YY_BREAK
                case 8:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::IDENTIFIER;
                    }
                    YY_BREAK
                case 9:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::CONST_INT;
                    }
                    YY_BREAK
                case 10:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::CONST_FLOAT;
                    }
                    YY_BREAK
                /* Anything that starts with a {DIGIT} or .{DIGIT} must be a number. */
                /* Rule to catch all invalid integers and floats. */
                case 11:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::PP_NUMBER;
                    }
                    YY_BREAK
                case 12:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_INC;
                    }
                    YY_BREAK
                case 13:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_DEC;
                    }
                    YY_BREAK
                case 14:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_LEFT;
                    }
                    YY_BREAK
                case 15:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_RIGHT;
                    }
                    YY_BREAK
                case 16:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_LE;
                    }
                    YY_BREAK
                case 17:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_GE;
                    }
                    YY_BREAK
                case 18:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_EQ;
                    }
                    YY_BREAK
                case 19:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_NE;
                    }
                    YY_BREAK
                case 20:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_AND;
                    }
                    YY_BREAK
                case 21:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_XOR;
                    }
                    YY_BREAK
                case 22:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_OR;
                    }
                    YY_BREAK
                case 23:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_ADD_ASSIGN;
                    }
                    YY_BREAK
                case 24:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_SUB_ASSIGN;
                    }
                    YY_BREAK
                case 25:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_MUL_ASSIGN;
                    }
                    YY_BREAK
                case 26:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_DIV_ASSIGN;
                    }
                    YY_BREAK
                case 27:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_MOD_ASSIGN;
                    }
                    YY_BREAK
                case 28:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_LEFT_ASSIGN;
                    }
                    YY_BREAK
                case 29:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_RIGHT_ASSIGN;
                    }
                    YY_BREAK
                case 30:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_AND_ASSIGN;
                    }
                    YY_BREAK
                case 31:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_XOR_ASSIGN;
                    }
                    YY_BREAK
                case 32:
                    YY_RULE_SETUP
                    {
                        yylval->assign(yytext, yyleng);
                        return angle::pp::Token::OP_OR_ASSIGN;
                    }
                    YY_BREAK
                case 33:
                    YY_RULE_SETUP
                    {
                        yylval->assign(1, yytext[0]);
                        return yytext[0];
                    }
                    YY_BREAK
                case 34:
                    YY_RULE_SETUP
                    {
                        yyextra->leadingSpace = true;
                    }
                    YY_BREAK
                case 35:
                    /* rule 35 can match eol */
                    YY_RULE_SETUP
                    {
                        if (yylineno == INT_MAX)
                        {
                            *yylval = "Integer overflow on line number";
                            return angle::pp::Token::GOT_ERROR;
                        }
                        ++yylineno;
                        yylval->assign(1, '\n');
                        return '\n';
                    }
                    YY_BREAK
                case 36:
                    YY_RULE_SETUP
                    {
                        yylval->assign(1, yytext[0]);
                        return angle::pp::Token::PP_OTHER;
                    }
                    YY_BREAK
                case YY_STATE_EOF(INITIAL):
                case YY_STATE_EOF(COMMENT):
                {
                    // YY_USER_ACTION is not invoked for handling EOF.
                    // Set the location for EOF token manually.
                    angle::pp::Input *input             = &yyextra->input;
                    angle::pp::Input::Location *scanLoc = &yyextra->scanLoc;
                    yy_size_t sIndexMax                 = input->count() ? input->count() - 1 : 0;
                    if (scanLoc->sIndex != sIndexMax)
                    {
                        // We can only reach here if there are empty strings at the
                        // end of the input.
                        scanLoc->sIndex = sIndexMax;
                        scanLoc->cIndex = 0;
                        // FIXME: this is not 64-bit clean.
                        yyfileno = static_cast<int>(sIndexMax);
                        yylineno = 1;
                    }
                    yylloc->file = yyfileno;
                    yylloc->line = yylineno;
                    yylval->clear();

                    // Line number overflows fake EOFs to exit early, check for this case.
                    if (yylineno == INT_MAX)
                    {
                        yyextra->diagnostics->report(angle::pp::Diagnostics::PP_TOKENIZER_ERROR,
                                                     angle::pp::SourceLocation(yyfileno, yylineno),
                                                     "Integer overflow on line number");
                    }
                    else if (YY_START == COMMENT)
                    {
                        yyextra->diagnostics->report(angle::pp::Diagnostics::PP_EOF_IN_COMMENT,
                                                     angle::pp::SourceLocation(yyfileno, yylineno),
                                                     "EOF while in a comment");
                    }
                    yyterminate();
                }
                    YY_BREAK
                case 37:
                    YY_RULE_SETUP
                    ECHO;
                    YY_BREAK

                case YY_END_OF_BUFFER:
                {
                    /* Amount of text matched not including the EOB char. */
                    int yy_amount_of_matched_text = (int)(yy_cp - yyg->yytext_ptr) - 1;

                    /* Undo the effects of YY_DO_BEFORE_ACTION. */
                    *yy_cp = yyg->yy_hold_char;
                    YY_RESTORE_YY_MORE_OFFSET

                    if (YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW)
                    {
                        /* We're scanning a new file or input source.  It's
                         * possible that this happened because the user
                         * just pointed yyin at a new source and called
                         * yylex().  If so, then we have to assure
                         * consistency between YY_CURRENT_BUFFER and our
                         * globals.  Here is the right place to do so, because
                         * this is the first action (other than possibly a
                         * back-up) that will match for the new input source.
                         */
                        yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
                        YY_CURRENT_BUFFER_LVALUE->yy_input_file    = yyin;
                        YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
                    }

                    /* Note that here we test for yy_c_buf_p "<=" to the position
                     * of the first EOB in the buffer, since yy_c_buf_p will
                     * already have been incremented past the NUL character
                     * (since all states make transitions on EOB to the
                     * end-of-buffer state).  Contrast this with the test
                     * in input().
                     */
                    if (yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars])
                    { /* This was really a NUL. */
                        yy_state_type yy_next_state;

                        yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

                        yy_current_state = yy_get_previous_state(yyscanner);

                        /* Okay, we're now positioned to make the NUL
                         * transition.  We couldn't have
                         * yy_get_previous_state() go ahead and do it
                         * for us because it doesn't know how to deal
                         * with the possibility of jamming (and we don't
                         * want to build jamming into it because then it
                         * will run more slowly).
                         */

                        yy_next_state = yy_try_NUL_trans(yy_current_state, yyscanner);

                        yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

                        if (yy_next_state)
                        {
                            /* Consume the NUL. */
                            yy_cp            = ++yyg->yy_c_buf_p;
                            yy_current_state = yy_next_state;
                            goto yy_match;
                        }

                        else
                        {
                            yy_cp            = yyg->yy_last_accepting_cpos;
                            yy_current_state = yyg->yy_last_accepting_state;
                            goto yy_find_action;
                        }
                    }

                    else
                    {
                        switch (yy_get_next_buffer(yyscanner))
                        {
                            case EOB_ACT_END_OF_FILE:
                            {
                                yyg->yy_did_buffer_switch_on_eof = 0;

                                if (yywrap(yyscanner))
                                {
                                    /* Note: because we've taken care in
                                     * yy_get_next_buffer() to have set up
                                     * yytext, we can now set up
                                     * yy_c_buf_p so that if some total
                                     * hoser (like flex itself) wants to
                                     * call the scanner after we return the
                                     * YY_NULL, it'll still work - another
                                     * YY_NULL will get returned.
                                     */
                                    yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

                                    yy_act = YY_STATE_EOF(YY_START);
                                    goto do_action;
                                }

                                else
                                {
                                    if (!yyg->yy_did_buffer_switch_on_eof)
                                    {
                                        YY_NEW_FILE;
                                    }
                                }
                                break;
                            }

                            case EOB_ACT_CONTINUE_SCAN:
                                yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

                                yy_current_state = yy_get_previous_state(yyscanner);

                                yy_cp = yyg->yy_c_buf_p;
                                yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
                                goto yy_match;

                            case EOB_ACT_LAST_MATCH:
                                yyg->yy_c_buf_p =
                                    &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

                                yy_current_state = yy_get_previous_state(yyscanner);

                                yy_cp = yyg->yy_c_buf_p;
                                yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
                                goto yy_find_action;
                        }
                    }
                    break;
                }

                default:
                    YY_FATAL_ERROR("fatal flex scanner internal error--no action found");
            } /* end of action switch */
        } /* end of scanning one token */
    } /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *    EOB_ACT_LAST_MATCH -
 *    EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *    EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    char *dest           = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
    char *source         = yyg->yytext_ptr;
    int number_to_move, i;
    int ret_val;

    if (yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1])
    {
        YY_FATAL_ERROR("fatal flex scanner internal error--end of buffer missed");
    }

    if (YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0)
    { /* Don't try to fill the buffer, so this is an EOF. */
        if (yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1)
        {
            /* We matched a single character, the EOB, so
             * treat this as a final EOF.
             */
            return EOB_ACT_END_OF_FILE;
        }

        else
        {
            /* We matched some text prior to the EOB, first
             * process it.
             */
            return EOB_ACT_LAST_MATCH;
        }
    }

    /* Try to read more data. */

    /* First move last chars to start of buffer. */
    number_to_move = (int)(yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

    for (i = 0; i < number_to_move; ++i)
    {
        *(dest++) = *(source++);
    }

    if (YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING)
    {
        /* don't do the read, it's not guaranteed to return an EOF,
         * just force an EOF
         */
        YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;
    }

    else
    {
        int num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

        while (num_to_read <= 0)
        { /* Not enough room in the buffer - grow it. */

            /* just a shorter name for the current buffer */
            YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

            int yy_c_buf_p_offset = (int)(yyg->yy_c_buf_p - b->yy_ch_buf);

            if (b->yy_is_our_buffer)
            {
                int new_size = b->yy_buf_size * 2;

                if (new_size <= 0)
                {
                    b->yy_buf_size += b->yy_buf_size / 8;
                }
                else
                {
                    b->yy_buf_size *= 2;
                }

                b->yy_ch_buf = (char *)
                    /* Include room in for 2 EOB chars. */
                    yyrealloc((void *)b->yy_ch_buf, (yy_size_t)(b->yy_buf_size + 2), yyscanner);
            }
            else
            {
                /* Can't grow it, we don't own it. */
                b->yy_ch_buf = NULL;
            }

            if (!b->yy_ch_buf)
            {
                YY_FATAL_ERROR("fatal error - scanner input buffer overflow");
            }

            yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

            num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;
        }

        if (num_to_read > YY_READ_BUF_SIZE)
        {
            num_to_read = YY_READ_BUF_SIZE;
        }

        /* Read in more data. */
        yy_size_t ret = 0;
        YY_INPUT((&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]), ret, num_to_read);
        yyg->yy_n_chars = static_cast<int>(ret);

        YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
    }

    if (yyg->yy_n_chars == 0)
    {
        if (number_to_move == YY_MORE_ADJ)
        {
            ret_val = EOB_ACT_END_OF_FILE;
            yyrestart(yyin, yyscanner);
        }

        else
        {
            ret_val                                    = EOB_ACT_LAST_MATCH;
            YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_EOF_PENDING;
        }
    }

    else
    {
        ret_val = EOB_ACT_CONTINUE_SCAN;
    }

    if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size)
    {
        /* Extend the array by 50%, plus the number we really need. */
        int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
        YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *)yyrealloc(
            (void *)YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t)new_size, yyscanner);
        if (!YY_CURRENT_BUFFER_LVALUE->yy_ch_buf)
        {
            YY_FATAL_ERROR("out of dynamic memory in yy_get_next_buffer()");
        }
        /* "- 2" to take care of EOB's */
        YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int)(new_size - 2);
    }

    yyg->yy_n_chars += number_to_move;
    YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars]     = YY_END_OF_BUFFER_CHAR;
    YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

    return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state(yyscan_t yyscanner)
{
    yy_state_type yy_current_state;
    char *yy_cp;
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    yy_current_state = yyg->yy_start;

    for (yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp)
    {
        YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
        if (yy_accept[yy_current_state])
        {
            yyg->yy_last_accepting_state = yy_current_state;
            yyg->yy_last_accepting_cpos  = yy_cp;
        }
        while (yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state)
        {
            yy_current_state = (int)yy_def[yy_current_state];
            if (yy_current_state >= 95)
            {
                yy_c = yy_meta[yy_c];
            }
        }
        yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    }

    return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *    next_state = yy_try_NUL_trans( current_state );
 */
static yy_state_type yy_try_NUL_trans(yy_state_type yy_current_state, yyscan_t yyscanner)
{
    int yy_is_jam;
    struct yyguts_t *yyg =
        (struct yyguts_t *)yyscanner; /* This var may be unused depending upon options. */
    char *yy_cp = yyg->yy_c_buf_p;

    YY_CHAR yy_c = 1;
    if (yy_accept[yy_current_state])
    {
        yyg->yy_last_accepting_state = yy_current_state;
        yyg->yy_last_accepting_cpos  = yy_cp;
    }
    while (yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state)
    {
        yy_current_state = (int)yy_def[yy_current_state];
        if (yy_current_state >= 95)
        {
            yy_c = yy_meta[yy_c];
        }
    }
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam        = (yy_current_state == 94);

    (void)yyg;
    return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#    ifdef __cplusplus
static int yyinput(yyscan_t yyscanner)
#    else
static int input(yyscan_t yyscanner)
#    endif

{
    int c;
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    *yyg->yy_c_buf_p = yyg->yy_hold_char;

    if (*yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR)
    {
        /* yy_c_buf_p now points to the character we want to return.
         * If this occurs *before* the EOB characters, then it's a
         * valid NUL; if not, then we've hit the end of the buffer.
         */
        if (yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars])
        {
            /* This was really a NUL. */
            *yyg->yy_c_buf_p = '\0';
        }

        else
        { /* need more input */
            int offset = (int)(yyg->yy_c_buf_p - yyg->yytext_ptr);
            ++yyg->yy_c_buf_p;

            switch (yy_get_next_buffer(yyscanner))
            {
                case EOB_ACT_LAST_MATCH:
                    /* This happens because yy_g_n_b()
                     * sees that we've accumulated a
                     * token and flags that we need to
                     * try matching the token before
                     * proceeding.  But for input(),
                     * there's no matching to consider.
                     * So convert the EOB_ACT_LAST_MATCH
                     * to EOB_ACT_END_OF_FILE.
                     */

                    /* Reset buffer status. */
                    yyrestart(yyin, yyscanner);

                    /*FALLTHROUGH*/

                case EOB_ACT_END_OF_FILE:
                {
                    if (yywrap(yyscanner))
                    {
                        return 0;
                    }

                    if (!yyg->yy_did_buffer_switch_on_eof)
                    {
                        YY_NEW_FILE;
                    }
#    ifdef __cplusplus
                    return yyinput(yyscanner);
#    else
                    return input(yyscanner);
#    endif
                }

                case EOB_ACT_CONTINUE_SCAN:
                    yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
                    break;
            }
        }
    }

    c                 = *(unsigned char *)yyg->yy_c_buf_p; /* cast for 8-bit char's */
    *yyg->yy_c_buf_p  = '\0';                              /* preserve yytext */
    yyg->yy_hold_char = *++yyg->yy_c_buf_p;

    return c;
}
#endif /* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
void yyrestart(FILE *input_file, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    if (!YY_CURRENT_BUFFER)
    {
        yyensure_buffer_stack(yyscanner);
        YY_CURRENT_BUFFER_LVALUE = yy_create_buffer(yyin, YY_BUF_SIZE, yyscanner);
    }

    yy_init_buffer(YY_CURRENT_BUFFER, input_file, yyscanner);
    yy_load_buffer_state(yyscanner);
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
void yy_switch_to_buffer(YY_BUFFER_STATE new_buffer, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    /* TODO. We should be able to replace this entire function body
     * with
     *        yypop_buffer_state();
     *        yypush_buffer_state(new_buffer);
     */
    yyensure_buffer_stack(yyscanner);
    if (YY_CURRENT_BUFFER == new_buffer)
    {
        return;
    }

    if (YY_CURRENT_BUFFER)
    {
        /* Flush out information for old buffer. */
        *yyg->yy_c_buf_p                     = yyg->yy_hold_char;
        YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
        YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
    }

    YY_CURRENT_BUFFER_LVALUE = new_buffer;
    yy_load_buffer_state(yyscanner);

    /* We don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yyg->yy_n_chars      = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
    yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
    yyin                              = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
    yyg->yy_hold_char                 = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
YY_BUFFER_STATE yy_create_buffer(FILE *file, int size, yyscan_t yyscanner)
{
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE)yyalloc(sizeof(struct yy_buffer_state), yyscanner);
    if (!b)
    {
        YY_FATAL_ERROR("out of dynamic memory in yy_create_buffer()");
    }

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (char *)yyalloc((yy_size_t)(b->yy_buf_size + 2), yyscanner);
    if (!b->yy_ch_buf)
    {
        YY_FATAL_ERROR("out of dynamic memory in yy_create_buffer()");
    }

    b->yy_is_our_buffer = 1;

    yy_init_buffer(b, file, yyscanner);

    return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
void yy_delete_buffer(YY_BUFFER_STATE b, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    if (!b)
    {
        return;
    }

    if (b == YY_CURRENT_BUFFER) /* Not sure if we should pop here. */
    {
        YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE)0;
    }

    if (b->yy_is_our_buffer)
    {
        yyfree((void *)b->yy_ch_buf, yyscanner);
    }

    yyfree((void *)b, yyscanner);
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
static void yy_init_buffer(YY_BUFFER_STATE b, FILE *file, yyscan_t yyscanner)

{
    int oerrno           = errno;
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    yy_flush_buffer(b, yyscanner);

    b->yy_input_file  = file;
    b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER)
    {
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

    b->yy_is_interactive = 0;

    errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
void yy_flush_buffer(YY_BUFFER_STATE b, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    if (!b)
    {
        return;
    }

    b->yy_n_chars = 0;

    /* We always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[0];

    b->yy_at_bol        = 1;
    b->yy_buffer_status = YY_BUFFER_NEW;

    if (b == YY_CURRENT_BUFFER)
    {
        yy_load_buffer_state(yyscanner);
    }
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state(YY_BUFFER_STATE new_buffer, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    if (new_buffer == NULL)
    {
        return;
    }

    yyensure_buffer_stack(yyscanner);

    /* This block is copied from yy_switch_to_buffer. */
    if (YY_CURRENT_BUFFER)
    {
        /* Flush out information for old buffer. */
        *yyg->yy_c_buf_p                     = yyg->yy_hold_char;
        YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
        YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
    }

    /* Only push if top exists. Otherwise, replace top. */
    if (YY_CURRENT_BUFFER)
    {
        yyg->yy_buffer_stack_top++;
    }
    YY_CURRENT_BUFFER_LVALUE = new_buffer;

    /* copied from yy_switch_to_buffer. */
    yy_load_buffer_state(yyscanner);
    yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    if (!YY_CURRENT_BUFFER)
    {
        return;
    }

    yy_delete_buffer(YY_CURRENT_BUFFER, yyscanner);
    YY_CURRENT_BUFFER_LVALUE = NULL;
    if (yyg->yy_buffer_stack_top > 0)
    {
        --yyg->yy_buffer_stack_top;
    }

    if (YY_CURRENT_BUFFER)
    {
        yy_load_buffer_state(yyscanner);
        yyg->yy_did_buffer_switch_on_eof = 1;
    }
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack(yyscan_t yyscanner)
{
    yy_size_t num_to_alloc;
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    if (!yyg->yy_buffer_stack)
    {

        /* First allocation is just for 2 elements, since we don't know if this
         * scanner will even need a stack. We use 2 instead of 1 to avoid an
         * immediate realloc on the next call.
         */
        num_to_alloc         = 1; /* After all that talk, this was set to 1 anyways... */
        yyg->yy_buffer_stack = (struct yy_buffer_state **)yyalloc(
            num_to_alloc * sizeof(struct yy_buffer_state *), yyscanner);
        if (!yyg->yy_buffer_stack)
        {
            YY_FATAL_ERROR("out of dynamic memory in yyensure_buffer_stack()");
        }

        memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state *));

        yyg->yy_buffer_stack_max = num_to_alloc;
        yyg->yy_buffer_stack_top = 0;
        return;
    }

    if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1)
    {

        /* Increase the buffer to prepare for a possible push. */
        yy_size_t grow_size = 8 /* arbitrary grow size */;

        num_to_alloc         = yyg->yy_buffer_stack_max + grow_size;
        yyg->yy_buffer_stack = (struct yy_buffer_state **)yyrealloc(
            yyg->yy_buffer_stack, num_to_alloc * sizeof(struct yy_buffer_state *), yyscanner);
        if (!yyg->yy_buffer_stack)
        {
            YY_FATAL_ERROR("out of dynamic memory in yyensure_buffer_stack()");
        }

        /* zero only the new slots.*/
        memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0,
               grow_size * sizeof(struct yy_buffer_state *));
        yyg->yy_buffer_stack_max = num_to_alloc;
    }
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer(char *base, yy_size_t size, yyscan_t yyscanner)
{
    YY_BUFFER_STATE b;

    if (size < 2 || base[size - 2] != YY_END_OF_BUFFER_CHAR ||
        base[size - 1] != YY_END_OF_BUFFER_CHAR)
    {
        /* They forgot to leave room for the EOB's. */
        return NULL;
    }

    b = (YY_BUFFER_STATE)yyalloc(sizeof(struct yy_buffer_state), yyscanner);
    if (!b)
    {
        YY_FATAL_ERROR("out of dynamic memory in yy_scan_buffer()");
    }

    b->yy_buf_size = (int)(size - 2); /* "- 2" to take care of EOB's */
    b->yy_buf_pos = b->yy_ch_buf = base;
    b->yy_is_our_buffer          = 0;
    b->yy_input_file             = NULL;
    b->yy_n_chars                = b->yy_buf_size;
    b->yy_is_interactive         = 0;
    b->yy_at_bol                 = 1;
    b->yy_fill_buffer            = 0;
    b->yy_buffer_status          = YY_BUFFER_NEW;

    yy_switch_to_buffer(b, yyscanner);

    return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string(const char *yystr, yyscan_t yyscanner)
{

    return yy_scan_bytes(yystr, (int)strlen(yystr), yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes(const char *yybytes, int _yybytes_len, yyscan_t yyscanner)
{
    YY_BUFFER_STATE b;
    char *buf;
    yy_size_t n;
    int i;

    /* Get memory for full buffer, including space for trailing EOB's. */
    n   = (yy_size_t)(_yybytes_len + 2);
    buf = (char *)yyalloc(n, yyscanner);
    if (!buf)
    {
        YY_FATAL_ERROR("out of dynamic memory in yy_scan_bytes()");
    }

    for (i = 0; i < _yybytes_len; ++i)
    {
        buf[i] = yybytes[i];
    }

    buf[_yybytes_len] = buf[_yybytes_len + 1] = YY_END_OF_BUFFER_CHAR;

    b = yy_scan_buffer(buf, n, yyscanner);
    if (!b)
    {
        YY_FATAL_ERROR("bad buffer in yy_scan_bytes()");
    }

    /* It's okay to grow etc. this buffer, and we should throw it
     * away when we're done.
     */
    b->yy_is_our_buffer = 1;

    return b;
}

#ifndef YY_EXIT_FAILURE
#    define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error(const char *msg, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    (void)yyg;
    fprintf(stderr, "%s\n", msg);
    exit(YY_EXIT_FAILURE);
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n)                                      \
    do                                                 \
    {                                                  \
        /* Undo effects of setting up yytext. */       \
        int yyless_macro_arg = (n);                    \
        YY_LESS_LINENO(yyless_macro_arg);              \
        yytext[yyleng]    = yyg->yy_hold_char;         \
        yyg->yy_c_buf_p   = yytext + yyless_macro_arg; \
        yyg->yy_hold_char = *yyg->yy_c_buf_p;          \
        *yyg->yy_c_buf_p  = '\0';                      \
        yyleng            = yyless_macro_arg;          \
    } while (0)

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    if (!YY_CURRENT_BUFFER)
    {
        return 0;
    }

    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    if (!YY_CURRENT_BUFFER)
    {
        return 0;
    }

    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra(YY_EXTRA_TYPE user_defined, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yyextra              = user_defined;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno(int _line_number, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    /* lineno is only valid if an input buffer exists. */
    if (!YY_CURRENT_BUFFER)
    {
        YY_FATAL_ERROR("yyset_lineno called with no buffer");
    }

    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column(int _column_no, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    /* column is only valid if an input buffer exists. */
    if (!YY_CURRENT_BUFFER)
    {
        YY_FATAL_ERROR("yyset_column called with no buffer");
    }

    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in(FILE *_in_str, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yyin                 = _in_str;
}

void yyset_out(FILE *_out_str, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yyout                = _out_str;
}

int yyget_debug(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yy_flex_debug;
}

void yyset_debug(int _bdebug, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yy_flex_debug        = _bdebug;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE *yyget_lval(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yylval;
}

void yyset_lval(YYSTYPE *yylval_param, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yylval               = yylval_param;
}

YYLTYPE *yyget_lloc(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    return yylloc;
}

void yyset_lloc(YYLTYPE *yylloc_param, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    yylloc               = yylloc_param;
}

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t *ptr_yy_globals)
{
    if (ptr_yy_globals == NULL)
    {
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t)yyalloc(sizeof(struct yyguts_t), NULL);

    if (*ptr_yy_globals == NULL)
    {
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals, 0x00, sizeof(struct yyguts_t));

    return yy_init_globals(*ptr_yy_globals);
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra(YY_EXTRA_TYPE yy_user_defined, yyscan_t *ptr_yy_globals)
{
    struct yyguts_t dummy_yyguts;

    yyset_extra(yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL)
    {
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t)yyalloc(sizeof(struct yyguts_t), &dummy_yyguts);

    if (*ptr_yy_globals == NULL)
    {
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals, 0x00, sizeof(struct yyguts_t));

    yyset_extra(yy_user_defined, *ptr_yy_globals);

    return yy_init_globals(*ptr_yy_globals);
}

static int yy_init_globals(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack     = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p          = NULL;
    yyg->yy_init             = 0;
    yyg->yy_start            = 0;

    yyg->yy_start_stack_ptr   = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack       = NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin  = stdin;
    yyout = stdout;
#else
    yyin  = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy(yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;

    /* Pop the buffer stack, destroying each element. */
    while (YY_CURRENT_BUFFER)
    {
        yy_delete_buffer(YY_CURRENT_BUFFER, yyscanner);
        YY_CURRENT_BUFFER_LVALUE = NULL;
        yypop_buffer_state(yyscanner);
    }

    /* Destroy the stack itself. */
    yyfree(yyg->yy_buffer_stack, yyscanner);
    yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
    yyfree(yyg->yy_start_stack, yyscanner);
    yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals(yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree(yyscanner, yyscanner);
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy(char *s1, const char *s2, int n, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    (void)yyg;

    int i;
    for (i = 0; i < n; ++i)
    {
        s1[i] = s2[i];
    }
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen(const char *s, yyscan_t yyscanner)
{
    int n;
    for (n = 0; s[n]; ++n)
        ;

    return n;
}
#endif

void *yyalloc(yy_size_t size, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    (void)yyg;
    return malloc(size);
}

void *yyrealloc(void *ptr, yy_size_t size, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    (void)yyg;

    /* The cast to (char *) in the following accommodates both
     * implementations that use char* generic pointers, and those
     * that use void* generic pointers.  It works with the latter
     * because both ANSI C and C++ allow castless assignment from
     * any pointer type to void*, and deal with argument conversions
     * as though doing an assignment.
     */
    return realloc(ptr, size);
}

void yyfree(void *ptr, yyscan_t yyscanner)
{
    struct yyguts_t *yyg = (struct yyguts_t *)yyscanner;
    (void)yyg;
    free((char *)ptr); /* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

namespace angle
{

namespace pp
{

Tokenizer::Tokenizer(Diagnostics *diagnostics) : mHandle(nullptr), mMaxTokenSize(256)
{
    mContext.diagnostics = diagnostics;
}

Tokenizer::~Tokenizer()
{
    destroyScanner();
}

bool Tokenizer::init(size_t count, const char *const string[], const int length[])
{
    if ((count > 0) && (string == 0))
    {
        return false;
    }

    mContext.input = Input(count, string, length);
    return initScanner();
}

void Tokenizer::setFileNumber(int file)
{
    // We use column number as file number.
    // See macro yyfileno.
    yyset_column(file, mHandle);
}

void Tokenizer::setLineNumber(int line)
{
    yyset_lineno(line, mHandle);
}

void Tokenizer::setMaxTokenSize(size_t maxTokenSize)
{
    mMaxTokenSize = maxTokenSize;
}

void Tokenizer::lex(Token *token)
{
    int tokenType = yylex(&token->text, &token->location, mHandle);

    if (tokenType == Token::GOT_ERROR)
    {
        mContext.diagnostics->report(Diagnostics::PP_TOKENIZER_ERROR, token->location, token->text);
        token->type = Token::LAST;
    }
    else
    {
        token->type = tokenType;
    }

    if (token->text.size() > mMaxTokenSize)
    {
        mContext.diagnostics->report(Diagnostics::PP_TOKEN_TOO_LONG, token->location, token->text);
        token->text.erase(mMaxTokenSize);
    }

    token->flags = 0;

    token->setAtStartOfLine(mContext.lineStart);
    mContext.lineStart = token->type == '\n';

    token->setHasLeadingSpace(mContext.leadingSpace);
    mContext.leadingSpace = false;
}

bool Tokenizer::initScanner()
{
    if ((mHandle == nullptr) && yylex_init_extra(&mContext, &mHandle))
    {
        return false;
    }

    yyrestart(0, mHandle);
    return true;
}

void Tokenizer::destroyScanner()
{
    if (mHandle == nullptr)
    {
        return;
    }

    yylex_destroy(mHandle);
    mHandle = nullptr;
}

}  // namespace pp

}  // namespace angle
