'''OpenGL extension MESA.texture_const_bandwidth

This module customises the behaviour of the 
OpenGL.raw.GL.MESA.texture_const_bandwidth to provide a more 
Python-friendly API

Overview (from the spec)
	
	The use of data dependent bandwidth compressed formats (UBWC, AFBC, etc)
	can introduce a form of side-channel, in that the bandwidth used for
	texture access is dependent on the texture's contents.  In some cases
	an application may want to disable the use of data dependent formats on
	specific textures.
	
	For that purpose, this extension extends EXT_memory_object to introduce
	a new <param> CONST_BW_TILING_MESA.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/MESA/texture_const_bandwidth.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.MESA.texture_const_bandwidth import *
from OpenGL.raw.GL.MESA.texture_const_bandwidth import _EXTENSION_NAME

def glInitTextureConstBandwidthMESA():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION