% PsychDocumentation -- Bits of documentation for Psychtoolbox
%
% This folder contains help files and info on different topics
% related to PTBs use, technical implementation and troubleshooting.
%
% Note that you can now financially contribute to Psychtoolbox sustainability,
% upkeep and continued improvement by buying a "Psychtoolbox Support Membership",
% which also includes some paid support for questions regarding its use, or
% issues you may have with it. We also offer paid feature development and
% other useful commercial services.
%
% Please type 'PsychPaidSupportAndServices' to learn more.
%
%
% AntiAliasing           - Psychtoolbox facilities for anti-aliased drawing and
%                          how to use them properly.
%
% BeampositionQueries    - Some technical information on how stimulus onset
%                          timing is determined by the Screen('Flip') command,
%                          and how PTB tests your setup for proper timing and
%                          synchronization with vertical retrace.
%
% ConserveVRAMSettings   - Explanation of some flags that you can use to
%                          enable special workarounds in Screen() for
%                          broken graphics drivers or hardware.
%
% DisplayOutputMappings  - How they work on multi-display setups, how to
%                          resolve problems.
%
% DrawTextEncodingLocaleSettings - How to specify the text input encoding for
%                                  text drawing.
%
% DrawTextPlugin         - Troubleshooting the plugin-based Screen('DrawText')
%                          high-quality text renderer.
%
% ECVP2010Poster_VisualTimingPrecision.pdf - Poster about the visual
%                          stimulus onset timing and timestamping precision
%                          of Psychtoolbox tested on different system
%                          configurations. Presented at ECVP 2010. This
%                          version adds multiple pages of comments and
%                          bonus information. It also contains a few more
%                          datapoints collected after ECVP.
%
% GStreamer              - Installation instructions for the GStreamer
%                          media framework.
%
% HybridGraphics         - The state of hybrid graphics laptop support and
%                          how to use them with proper timing.
%
% InstallKinect          - Installation instructions for the Kinect
%                          drivers.
%
% KbQueue.html           - How to use keyboard queues.
%
% LinuxGameMode          - How to setup Linux performance optimizations via
%                          "GameMode".
%
% MirrorMode             - Special considerations regarding the use or
%                          non-use of display mirror mode on multi display
%                          setups or Laptops.
%
% MultiDisplaySetups     - Info on how to handle and use multi display setups.
%
% NVision3D              - Explanation of experimental NVision stereo goggle
%                          support.
%
% Oculus_Health_and_Safety_Warnings.pdf - Info about how to use the Oculus
%                          VR virtual reality headsets safely.
%
% ProceduralShadingAPI   - Documentation useful for procedural shading.
%
% ProgrammingTips.html   - A very incomplete programming manual.
%
% PsychPaidSupportAndServices - Our commercial support and service offerings.
%
% PsychtoolboxKernelDriver - How to set up the low-level support driver for
%                            Apple OSX.
%
% PTBTutorial-ECVP2013.pdf - The slides from the ECVP 2013 tutorial, with
%                            an introduction into basic Psychtoolbox features.
%
% RaspberryPiSetup       - How to setup a RasperryPi for Psychtoolbox, and
%                          what to expect.
%
% RetinaDisplay          - How to deal with HiDPI "Retina" displays.
%
% SyncTrouble            - Problem with synchronization to the vertical
%                          retrace or display timing, and how to resolve
%                          them.
%
% TouchInput             - Support for touch input devices.
%
% UseTheSource           - How to get access to the Psychtoolbox source code.
%
% VideoRecording         - Parameter settings, howtos and tips for Video recording.
%
% VRRSupport             - How to set up and use variable refresh rate (VRR) displays.
%
