/* Do not edit directly. See build-aux directory */
#pragma once

#include <glib.h>

#ifndef __GTK_DOC_IGNORE__
#define FONT_MANAGER_MAX_VENDOR_ID_LENGTH 4
#define FONT_MANAGER_MAX_VENDOR_LENGTH 100
#endif

static const struct
{
    const gchar vendor[FONT_MANAGER_MAX_VENDOR_LENGTH];
    const gchar vendor_id[FONT_MANAGER_MAX_VENDOR_LENGTH];
}
/* Order is significant. */
FontManagerNoticeData [] =
{
    /* Notice data sourced from fcfreetype.c - http://www.freetype.org/ */
    {"Adobe", "adobe"},
    {"Adobe", "Adobe"},
    {"Bigelow & Holmes", "b&h"},
    {"Bigelow & Holmes", "Bigelow & Holmes"},
    {"Bitstream", "Bitstream"},
    {"Font21", "hwan"},
    {"Font21", "Hwan"},
    {"Gnat", "culmus"},
    {"HanYang System", "hanyang"},
    {"HanYang System", "HanYang Information & Communication"},
    {"IBM", "IBM"},
    {"ITC", "itc"},
    {"ITC", "ITC"},
    {"ITC", "International Typeface Corporation"},
    {"Larabiefonts", "Larabie"},
    {"Linotype", "linotype"},
    {"Linotype", "Linotype GmbH"},
    {"Linotype", "LINOTYPE-HELL"},
    {"Microsoft", "microsoft"},
    {"Microsoft", "Microsoft Corporation"},
    {"Monotype", "Monotype Imaging"},
    {"Monotype", "Monotype Corporation"},
    {"Monotype", "Monotype Typography"},
    {"Omega", "omega"},
    {"Omega", "Omega"},
    {"Tiro Typeworks", "Tiro Typeworks"},
    {"URW", "URW"},
    {"XFree86", "XFree86"},
    {"Xorg", "xorg"}
};

static const struct
{
    const gchar vendor_id[FONT_MANAGER_MAX_VENDOR_ID_LENGTH];
    const gchar vendor[FONT_MANAGER_MAX_VENDOR_LENGTH];
}
FontManagerVendorData[] =
{

    /* Various Sources */
    {"ACG", "Monotype Imaging"},
    {"B?", "Bigelow & Holmes"},
    {"FJ", "Fujitsu"},
    {"RICO", "Ricoh"},


    /* Courtesy of Microsoft Typography - https://docs.microsoft.com/en-us/typography/vendors/ */
    {"!666", "Agyei Archer"},
    {"!ETF", "!xclamachine Type Foundry"},
    {"!YNE", "Yne"},
    {"$pro", "CheapProFonts"},
    {"(FT)", "Fuerte Type"},
    {"(K)", "KOMETA"},
    {"@", "Arrow Type"},
    {"@MT", "MarkType"},
    {"0.IZ", "0.itemzero"},
    {"00F3", "Óliver Lalan"},
    {"100", "AUTHENTIC"},
    {"123", "Numbers Font Foundry"},
    {"0264", "Patricia Lillie"},
    {"0909", "Oladino"},
    {"1206", "yayoyuyue"},
    {"1995", "San Sagittarius"},
    {"3011", "LuxSVG"},
    {"1ASC", "Ascender Corporation"},
    {"1BOU", "Boutros International"},
    {"1dot", "I.Font Project"},
    {"1FAN", "One Fan Foundry"},
    {"1KTF", "Kief Type Foundry"},
    {"1UKR", "AndrijType"},
    {"205", "205TF"},
    {"2000", "2000px Media Inc."},
    {"2DLT", "2D Typo"},
    {"2REB", "2Rebels"},
    {"3011", "LuxSVG"},
    {"3103", "Foxlify"},
    {"3270", "Ricardo Bánffy"},
    {"39BC", "Finley's Barcode Fonts"},
    {"3ip", "Three Islands Press"},
    {"3tp", "3type"},
    {"4A", "4A LLC"},
    {"4FEB", "4th february"},
    {"50FX", "50Fox Studio"},
    {"53VN", "Seun Badejo"},
    {"5PTS", "Five Points Technology"},
    {"6666", "Designova"},
    {"6789", "Greentrik6789"},
    {"72PT", "72 Puntos"},
    {"8686", "SVG Idea"},
    {"918", "RavenType"},
    {"9999", "Cricut Market"},
    {"A&S", "Art&Sign Studio"},
    {"A&TP", "Art & Type"},
    {"A70", "AutumnSeventy"},
    {"A2", "A2-Type"},
    {"AAA", "AlefAlefAlef"},
    {"aaff", "AstroAcademia Font Foundry"},
    {"AA", "Alireza Alipour"},
    {"AARN", "Aaron212"},
    {"AAT", "AhmetAltunType"},
    {"AATF", "Abstract Animal Type Foundry"},
    {"ABBO", "Arabic Dictionary Lab"},
    {"ABC", "Altek Instruments"},
    {"ABCD", "Dinamo Typefoundry"},
    {"ABCO", "About Contact"},
    {"ABCX", "ABC ETC INC"},
    {"ABEL", "Abeltive"},
    {"ABOU", "Aboutype, Inc."},
    {"ABTS", "alphabeet, Type Studio"},
    {"ABYM", "Abyme"},
    {"AC", "AllCaps"},
    {"ACT2", "Ansel Zhong (白云岫)"},
    {"ACUT", "Acute Type"},
    {"ACW", "Andrew Christopher West (BabelStone)"},
    {"Ad56", "Devotees of Sri Sri Ravi Shankar Ashram"},
    {"Adam", "Adam Jagosz"},
    {"ADBE", "Adobe"},
    {"ADBO", "Adobe"},
    {"ADG", "Apply Design Group"},
    {"AEF", "Altered Ego Fonts"},
    {"AES", "AE Type"},
    {"AFOU", "a.Foundry"},
    {"AGC", "André G. Costa"},
    {"AGFA", "Monotype Imaging (replaced by MONO)"},
    {"AGIA", "LaMagia"},
    {"AID", "Artistic Imposter Design"},
    {"aide", "Aiolfi.design"},
    {"AIFF", "Idiofonts"},
    {"AIYR", "Aiyari"},
    {"AJL", "Alex John Lucas"},
    {"AJPT", "Alan Jay Prescott Typography"},
    {"AKDL", "AK Design Lab"},
    {"AKOF", "AKOFAType"},
    {"AKRU", "Akuru Foundry"},
    {"AL", "Alessio Laiso Type"},
    {"ALEF", "Alef Type"},
    {"ALFA", "Alphabets"},
    {"ALFT", "Alifinart Studio"},
    {"ALIF", "Alif Type"},
    {"ALPH", "Alphameric Broadcast Solutions Limited"},
    {"ALPN", "Alpona Portal"},
    {"ALS", "Art. Lebedev Studio"},
    {"alte", "Altemus"},
    {"ALTR", "alterType"},
    {"ALTS", "Altsys / Made with Fontographer"},
    {"AMB", "AmbType"},
    {"amcs", "Amit soni"},
    {"amin", "fontamin"},
    {"AMPR", "Ampersand"},
    {"AMUN", "Alanna Munro Type"},
    {"AMUT", "Kwesi Amuti"},
    {"ANDO", "Osam Ando"},
    {"ANDR", "André Simard Typedesigner"},
    {"ANGT", "Anagata"},
    {"anir", "Dr Anirban Mitra"},
    {"ANRT", "Atelier National de Recherche Typographique"},
    {"ANSL", "Ansel Zhong (白云岫)"},
    {"anty", "Anatoletype"},
    {"AOP", "an Art Of Pengwyn"},
    {"APCX", "Another Planet Font Foundry"},
    {"APF", "All Purpose Fonts"},
    {"APLY", "Apply Interactive"},
    {"APOS", "Apostrophic Laboratories"},
    {"APPL", "Apple"},
    {"APTF", "Apoorva Fontech"},
    {"ARAB", "ArabicType Ltd"},
    {"ARAV", "Aravis Fonts"},
    {"ARBX", "Arabetics"},
    {"ARCH", "Architext"},
    {"ARFS", "And Repeat"},
    {"ARGN", "Alpha Argon"},
    {"ARIN", "Aring Typeface AB"},
    {"ARit", "Arabia-it"},
    {"ARMA", "Arman Khorramak"},
    {"ARPH", "Arphic Technology Co."},
    {"ARQX", "Archelogix Inc."},
    {"ARS", "EN ARS Ltd."},
    {"ART", "Alex Rosario Type"},
    {"ARTA", "Tarumian"},
    {"ARTE", "Artegra"},
    {"ArTy", "Archive Type"},
    {"AS", "Alex Slobzheninov"},
    {"ASL", "Abneil Software Ltd fonts"},
    {"ASSA", "astype"},
    {"ASYM", "Applied Symbols"},
    {"At", "Arilla Type Studio"},
    {"ATEC", "Page Technology Marketing, Inc."},
    {"ATF", "American Type Founders Collection"},
    {"ATFF", "ArabType Font Foundry"},
    {"ATF1", "Australian Type Foundry"},
    {"ATFM", "Asira Type Foundry"},
    {"ATFS", "Andrew Tyler's fonts"},
    {"athk", "atelier type hong kong"},
    {"ATKN", "aratakana"},
    {"ATKS", "ATK Studio"},
    {"ATLR", "Atelier Triay"},
    {"ATLS", "Atlas Fonts"},
    {"ATPK", "Atelier Pickard"},
    {"ATS", "Average Type Service"},
    {"ATSM", "Akshara Type Studio"},
    {"ATYP", "Attype Studio"},
    {"AUH", "Atelier Ursula Heilig SGD"},
    {"AURE", "Aure Font Design"},
    {"AUTO", "Autodidakt"},
    {"AVFF", "Agustín Varela Font Factory"},
    {"AvGd", "Avante Vangard Publishing Tools"},
    {"AVP", "Aviation Partners"},
    {"AVT", "AvanType Foundry"},
    {"AWSM", "Font Awesome"},
    {"AX86", "ax86.net"},
    {"AY", "Alen Yang"},
    {"AYRE", "AYRES FONTS"},
    {"AZLS", "Azalea Software, Inc."},
    {"b52", "Borno52 Font Foundry"},
    {"B&H", "Bigelow & Holmes"},
    {"BABA", "alibaba"},
    {"BAPS", "Baps Patil"},
    {"BARS", "CIA (BAR CODES) UK"},
    {"BASE", "Baseline Fonts"},
    {"BAT", "BUREAU DES AFFAIRES TYPOGRAPHIQUES"},
    {"BB", "Ben Busby"},
    {"BBBB", "Bea Korsh Type Design"},
    {"BBFF", "Bangla Borno Font Foundry."},
    {"BBOX", "bBox Type GmbH"},
    {"BBSL", "BrainBox Solutions GmbH"},
    {"BBTF", "buero bauer"},
    {"BBTL", "Banglagraphy Bangla Type Library"},
    {"BBTY", "Bruno Bernard Typographie"},
    {"BCAI", "Boharat Cairo"},
    {"BCHF", "Blake Hodgetts Fonts"},
    {"BCHN", "Studio Buchanan"},
    {"BCP", "Expert Labels Ltd."},
    {"BD71", "Bangladesh1971"},
    {"BDTD", "Typedifferent"},
    {"BDZ", "Bonez Designz"},
    {"BE", "typografie"},
    {"BEAR", "Topography Typography"},
    {"BEN", "Ben Hodosi"},
    {"BERT", "Berthold"},
    {"BEST", "Bespoke Type"},
    {"BF", "BrassFonts"},
    {"BFGS", "BrassFonts"},
    {"bftr", "Bleed Design Studio"},
    {"BGDN", "Ryan Bugden"},
    {"bgtl", "bigital"},
    {"BHRT", "Boharat Cairo"},
    {"BIJU", "Bijou Type"},
    {"BIRD", "Magpie Paper Works"},
    {"BITM", "Bitmap Software"},
    {"BITS", "Bitstream"},
    {"bizf", "Bizfonts.com"},
    {"BJHa", "Ben Harris"},
    {"BL", "Binnenland"},
    {"BLAB", "BaseLab"},
    {"BLAH", "Mister Bla's Fontworx"},
    {"BLCK", "Black Foundry"},
    {"BLF", "Bangla Lipikar Font Foundry"},
    {"BLFF", "Bongolipi Font Foundry"},
    {"BLI", "Blissym Language Institute"},
    {"BLIF", "Bangla Lipi Font Foundry"},
    {"BLK", "Blackletra Type Foundry"},
    {"BLKT", "Biliktu Foundry"},
    {"BLOM", "Bloom Type"},
    {"BLST", "Blast Foundry"},
    {"BLTS", "Blancoletters"},
    {"BLUE", "Blue Shell"},
    {"BLV", "Bladvulling"},
    {"BLZT", "Blaze Type"},
    {"BM86", "Madzonga"},
    {"BMD", "Brittney Murphy Design"},
    {"BNDR", "Ori Ben-Dor"},
    {"BNFF", "BengalFonts"},
    {"BNT", "Brand New Type"},
    {"BOGG", "Giulia B."},
    {"BOGS", "Bogstav"},
    {"BOLD", "Bold Monday"},
    {"BOLT", "Bolt Cutter Type"},
    {"BOMF", "Beach-o-matic"},
    {"BOOM", "Boom-Promphans"},
    {"BORW", "em2 Solutions"},
    {"BOUF", "Bou Fonts"},
    {"BOYB", "BoyBeaver Fonts"},
    {"BRBT", "Bureau Brut"},
    {"BRDV", "BoardVantage, Inc."},
    {"brdy", "Brody Fonts"},
    {"BREM", "Mark Bremmer"},
    {"BRET", "Bretagne"},
    {"BRIJ", "Brijesh Jivani"},
    {"BROS", "Michael Brosnan"},
    {"BRTC", "ITSCO - Bar Code Fonts"},
    {"BRTE", "Brenners Template"},
    {"BRWN", "Brown Type"},
    {"BS", "Barcodesoft"},
    {"BST", "Bolorsoft LLC"},
    {"BSTD", "Bastard Type Inc"},
    {"BSTF", "British Standard Type"},
    {"BSYV", "Ben Syverson"},
    {"BTF", "Bangla Type Foundry"},
    {"BTFF", "Bangla Type Font Foundry"},
    {"BTYP", "BeeType"},
    {"BUBU", "BUBULogix"},
    {"Buer", "Buernia"},
    {"BVH", "BVH Type Foundry"},
    {"BWFW", "B/W Fontworks"},
    {"BWJC", "不务鸡字体"},
    {"BwT", "Branding with Type"},
    {"BZER", "Bézier"},
    {"C&B", "Coppers & Brasses"},
    {"C&C", "Carter & Cone"},
    {"C&G", "C&G Inc."},
    {"C21", "Club 21"},
    {"CAB", "CabargaType"},
    {"CAD3", "Clipartdesign"},
    {"CAF", "CHOA FONT"},
    {"CAFE", "Cafe24 Corp."},
    {"CAK", "pluginfonts.com"},
    {"CAL", "California Type Foundry"},
    {"CAM", "Camelot Typefaces"},
    {"camp", "Campotype"},
    {"CANA", "Canada Type"},
    {"CANO", "Canon"},
    {"CAPE", "Cape Arcona Type Foundry"},
    {"CASL", "H.W. Caslon & Company Ltd."},
    {"CATG", "CAT-Fonts Germany"},
    {"CAVE", "Fonderia Cavedoni"},
    {"CB", "Christian Büning"},
    {"CBDO", "Borges Lettering & Design"},
    {"CBWJ", "不务正业的小鸡 (cod'dte)"},
    {"CCCT", "Cho Choi Creative"},
    {"CDAC", "Centre for Development of Advanced Computing"},
    {"cdd", "Crazy Diamond Design"},
    {"CDFP", "VT2000 Technical Services"},
    {"CELB", "Celebrity Fontz"},
    {"CENT", "Central Type"},
    {"CERC", "Cercurius"},
    {"CF", "Colophon Foundry"},
    {"CFA", "Computer Fonts Australia"},
    {"CFAB", "Creative Fabrica"},
    {"CFF", "Characters Font Foundry"},
    {"CHAI", "Tall Chai"},
    {"CHIC", "CHIC Type"},
    {"CHLL", "Chill Type"},
    {"CHRY", "Cherry Fonts"},
    {"CHTY", "Character Type"},
    {"CINE", "Cinetype"},
    {"CJCJ", "Creative Juncture"},
    {"CJT", "CJ Type"},
    {"CKTP", "CakeType"},
    {"CLM", "Culmus Project"},
    {"CLP", "Gutenberg Labo"},
    {"CLNT", "Cloanto"},
    {"CLT", "Collletttivo"},
    {"CLVR", "Font Clover"},
    {"CMDX", "Cory Maylett Design"},
    {"CMJK", "Slanted Hall"},
    {"CMMA", "Comma Type"},
    {"CNK", "Cinketype"},
    {"CNTY", "CNTYPE"},
    {"CNTP", "Contextype"},
    {"COFM", "Contraforma Fundidora"},
    {"COFO", "Contrast Foundry"},
    {"COLM", "ColumnType"},
    {"COMI", "Comicraft"},
    {"COMM", "Commercial Type"},
    {"CONR", "Connare.com"},
    {"CONT", "Contemporary Type"},
    {"COOL", "Cool Fonts"},
    {"CORD", "corduroy"},
    {"corm", "Cormullion Foundry"},
    {"COTF", "CoType Foundry"},
    {"COTY", "CocijoType"},
    {"CP", "Constructive Projects Ltd"},
    {"CR8", "CR8 Software Solutions"},
    {"CRRT", "Carrot Type"},
    {"CSCF", "Casasin Custom Fonts"},
    {"CSDA", "Creative Sauce FZ LLC"},
    {"csmp", "cosmope type"},
    {"CSTM", "CSTM Fonts"},
    {"CT", "CastleType"},
    {"CTCO", "Colt Type Co."},
    {"CTDL", "China Type Designs Ltd."},
    {"CTL", "Chaitanya Type Library"},
    {"CTYP", "Countertype"},
    {"CUBI", "CubicType"},
    {"cwwf", "Computers World Wide/AC Capital Funding"},
    {"CYPE", "Club Type"},
    {"CYRE", "Cyreal"},
    {"CYTY", "Cybertype"},
    {"CZOO", "Creative ZOO"},
    {"D&ST", "Dots&Stripes Type"},
    {"D502", "DisneySVG"},
    {"DADA", "Dada Studio"},
    {"DAIN", "DainType"},
    {"DAMA", "Dalton Maag Limited"},
    {"DARK", "Out Of The Dark"},
    {"DB", "Daniel Bruce"},
    {"DBFF", "DesignBase"},
    {"DC", "Domicile Foundry"},
    {"DD", "Devon DeLapp"},
    {"DDT", "DosDiez Type"},
    {"Deco", "DecoType (replaced by DT)"},
    {"DELV", "Delve Fonts"},
    {"DETF", "Detective Fonts / Font Detective LLC"},
    {"dezc", "Dezcom"},
    {"DF", "Dyslexic Font"},
    {"DFHA", "deFharo"},
    {"DFS", "Datascan Font Service Ltd"},
    {"DG", "Daniel Grumer"},
    {"DGL", "Digital Graphic Labs foundry"},
    {"DHRM", "Dharma Type"},
    {"DICO", "Dicotype"},
    {"DIFO", "Digital Foundry"},
    {"DIMK", "Dimka Fonts"},
    {"DJDJ", "Dominik Jáger"},
    {"djr", "DJR"},
    {"DKMS", "Dan Kreider Music"},
    {"DKSP", "Duck Soup Design"},
    {"dmol", "David Moles"},
    {"DNF", "Deranged Neko Foundry"},
    {"DnGr", "DevnGraphics"},
    {"DOCS", "Documents Inc."},
    {"DOM", "Dukom Design"},
    {"DonR", "Donat Raetzo"},
    {"DONS", "Don SVG Files"},
    {"DOT", "DDOTT Typefoundry"},
    {"DP", "Displaay"},
    {"DR", "Dmitry Rastvortsev"},
    {"DRFN", "DR Fonts"},
    {"DRT", "Dave Rowland Type"},
    {"DS", "Dainippon Screen Mfg. Co., Inc."},
    {"dsbn", "Design Bundles"},
    {"DSBV", "Datascan bv"},
    {"DSCI", "Design Science Inc."},
    {"DSGN", "DizajnDesign"},
    {"DSKY", "Jacek Dziubinski"},
    {"DSLF", "Dsl Fonts Type Foundry"},
    {"DSSR", "Dresser Johnson"},
    {"DSST", "Dubina Nikolay"},
    {"DST", "DSType"},
    {"DSTE", "Dieste"},
    {"DT", "DecoType"},
    {"DTC", "Digital Typeface Corp."},
    {"DTF", "Dunwich Type Founders"},
    {"DTIL", "Detail Type Foundry"},
    {"DTL", "Dutch Type Library"},
    {"DTPS", "DTP-Software"},
    {"dtpT", "dtpTypes Limited"},
    {"DTSM", "Shimada Mizuki (Ender7 Tina / 岛田水木)"},
    {"DTZM", "Dotzeem"},
    {"DUAL", "DualType"},
    {"DUXB", "Duxbury Systems, Inc."},
    {"DXTF", "DXTypefoundry"},
    {"DY", "Dmitry Ivanov"},
    {"DYNA", "DynaComware"},
    {"DZRF", "Dzus Rhythm Font Foundry"},
    {"EAFN", "EA FONTS"},
    {"EAST", "East of Rome"},
    {"EB", "Électro-bibliothèque"},
    {"ECAL", "ECAL Typefaces"},
    {"EDBI", "edilbiStudio"},
    {"EDGE", "Rivers Edge Corp."},
    {"EDU", "EDUfonts"},
    {"EF", "Elsner+Flake"},
    {"EFF", "Electronic Font Foundry"},
    {"EFFD", "Erik Faulhaber Font-Design"},
    {"EFI", "Elfring Fonts Inc."},
    {"EFNT", "E Fonts L.L.C."},
    {"EFWS", "eFilm World"},
    {"Egg9", "EGG9 font"},
    {"EINW", "David Einwaller"},
    {"EKIO", "Ekioh"},
    {"EKTF", "EK TYPE"},
    {"ELE", "Elefonts"},
    {"ELEO", "Enliteleo"},
    {"ELLR", "Eller Type"},
    {"ELSE", "Elseware"},
    {"EMGR", "Emigre"},
    {"EMPH", "Emphase"},
    {"EPSN", "Epson"},
    {"ERKO", "Erkin Karamemet"},
    {"ESAD", "X Cicéro"},
    {"ESD", "Sogari Design"},
    {"ESIG", "E-Signature"},
    {"ESTF", "Extraset Typefoundry"},
    {"ET", "Esintype"},
    {"ETAL", "Lettersetal"},
    {"ETCO", "Etcetera Type Company"},
    {"ETDF", "E-Type Design"},
    {"ETIO", "Ethiopian Font Foundry"},
    {"ETYM", "Etymos"},
    {"EVER", "Evertype"},
    {"F5", "Foundry5"},
    {"FA", "FontArte Type Foundry"},
    {"FA37", "F37 Foundry"},
    {"FAFO", "FamiraFonts"},
    {"FAIR", "Faire Type"},
    {"FAM", "Family Type"},
    {"FANC", "字言字型 Fancytype foundry/字言字語"},
    {"FARH", "Peter Verheul (cc)"},
    {"FAT", "Fatype"},
    {"FAUX", "FauxFoundry"},
    {"FAY", "FayType"},
    {"fbf", "Free Bangla Font Project"},
    {"FBI", "The Font Bureau, Inc."},
    {"FBRC", "Fabric Font"},
    {"FBRO", "FaizType."},
    {"FC", "Font.Cafe"},
    {"FCAB", "The Font Cabinet"},
    {"FCAN", "fontage canada"},
    {"FCB", "Font Club Belgica"},
    {"FCTP", "Facetype"},
    {"FDI", "FDI fonts.info"},
    {"FeCo", "FerCozzi."},
    {"FEED", "Studio Feed Inc."},
    {"FeoN", "Feòrag NìcBhrìde"},
    {"FeTy", "Feliciano Type"},
    {"FETZ", "Markus Fetz"},
    {"FFBR", "Fontfabric"},
    {"FFF", "Final Final Foundry"},
    {"FFFF", "Fabiola Mejía"},
    {"FG", "Font.Gold"},
    {"FGOD", "FontGod"},
    {"FHF", "Fanny Hamelin"},
    {"FHTP", "Fabio Haag Type"},
    {"FILI", "Louise Fili Ltd"},
    {"FIRA", "Firasoft Fonts"},
    {"FIRE", "youbringfire"},
    {"FIRM", "TYPE FIRM"},
    {"FJ", "frncojonas"},
    {"FJR", "F.J.R. German Typeface"},
    {"FJTY", "Frank Jonen - Illustration & Typography"},
    {"FK", "Florian Karsten Typefaces"},
    {"FKAI", "Font-Kai"},
    {"FKT", "Formerly Known"},
    {"FL", "Flight Mode Foundry"},
    {"FM", "FontMo"},
    {"FMFO", "Fontmill Foundry"},
    {"FMLJ", "Familjen"},
    {"FNBD", "FontBD Type Foundry"},
    {"FNKI", "Font Kitchen"},
    {"FNSA", "Fonseca Fonts"},
    {"fntb", "Font Bundles"},
    {"FNTF", "Fontfoundry"},
    {"FNTP", "FansyType"},
    {"FoFa", "FontFabrik"},
    {"fofm", "Font FM"},
    {"FOGC", "Fog City Type"},
    {"FoHa", "The Fonthausen Font Foundry"},
    {"FONT", "Font Source"},
    {"FONZ", "Font Zone 108"},
    {"FOR", "Formagari"},
    {"FORM", "Formation Type Foundry"},
    {"FORT", "Fort Foundry"},
    {"FOS", "FonStorage"},
    {"FOSH", "Forgotten Shapes"},
    {"FOSP", "Font Spectrum"},
    {"FOST", "Foster Type"},
    {"FOUN", "The Foundry"},
    {"FP", "The Fontpad"},
    {"FPKY", "Fitzgerald P. K. (Fitzgerald Yu / 蔽芪茢·茇䓮·蓲䒤菥)"},
    {"FPPL", "FontPeople"},
    {"FPTF", "Fontplat Type Foundry"},
    {"frag", "fragTYPE"},
    {"FRGT", "Freight Collection"},
    {"FRJN", "Frere-Jones Type"},
    {"FRML", "formlos"},
    {"FRNK", "Frank Fonts"},
    {"FRNZ", "Franziska Weitgruber"},
    {"FRTH", "Forthcome"},
    {"FS", "Formula Solutions"},
    {"FSD", "Fabrizio Schiavi Design"},
    {"FSE", "Font Source Europe"},
    {"FSFS", "Fontastica"},
    {"FSI", "FontShop International"},
    {"FSL", "FontSurfer Ltd"},
    {"FSLF", "Fontself"},
    {"fsmi", "Fontsmith"},
    {"FSTR", "Fontstore Pte Ltd"},
    {"FT", "Formula Type"},
    {"FTC", "Fridaytype"},
    {"FTDS", "FONTDASU"},
    {"FTF", "Fontef"},
    {"FTFT", "FontFont"},
    {"FTGD", "Font Garden"},
    {"FTH", "For the Hearts"},
    {"FTN", "Fountain"},
    {"FTPT", "Fontpartners"},
    {"FUNA", "Mt. Funa Design Office"},
    {"FVL", "Font Viet Linh"},
    {"FWD", "Fontwright Design"},
    {"FWKS", "Fontworks"},
    {"FWRE", "Fontware Limited"},
    {"FXTL", "Foxtail Collectif"},
    {"FXTP", "FoxType Co"},
    {"FY", "Fontyou"},
    {"GAF", "Glifo Art Fonts Inc."},
    {"GAKU", "Gakumon"},
    {"GALA", "Galápagos Design Group, Inc."},
    {"GALW", "Galway Cultural Development and Activity Compan…"},
    {"GALO", "Gerald Gallo"},
    {"GARI", "Gary Ritchie"},
    {"GATF", "Greater Albion Typefounders"},
    {"Gco", "Glyph Co"},
    {"GD", "GD Fonts"},
    {"GEEZ", "Geezfonts"},
    {"GenT", "General Titles"},
    {"GF", "GarageFonts"},
    {"GFNT", "Graffont"},
    {"GFT", "Geez Font Types"},
    {"GGWA", "Grenzgänger"},
    {"GIA", "Georgian Internet Avenue"},
    {"GIFT", "Souvenir Typefaces"},
    {"GIGA", "St. GIGAFONT Typefaces (stgiga)"},
    {"GKOU", "GEEKOU.IO"},
    {"GLCF", "GLC foundry"},
    {"GLDN", "Studio Gulden"},
    {"GLGX", "Golgex Design"},
    {"GLIN", "Glintelen"},
    {"GLYF", "Glyph Systems"},
    {"GNRL", "General Type Studio"},
    {"GNU", "Free Software Foundation, Inc."},
    {"GOAT", "Dingbat Dungeon"},
    {"GOGO", "Fonts-A-Go-Go"},
    {"GOHE", "GoHebrew, division of GoME2.com Inc."},
    {"GOOG", "Google"},
    {"Goss", "Goss Typography"},
    {"GPI", "Gamma Productions, Inc."},
    {"GRAF", "Grafikarna d.o.o."},
    {"GRCR", "Graphicore"},
    {"GREY", "Greyletter"},
    {"GRIL", "Grilled cheese"},
    {"GRIM", "Legacy publishing"},
    {"GRPS", "Gurup Stüdyo"},
    {"grro", "grafikk RØren"},
    {"GS", "Grayscale Limited"},
    {"GT", "Graphity!"},
    {"GTF", "Grilli Type"},
    {"GTff", "Greg Thompson Type"},
    {"GTL", "GTL Type Label"},
    {"GTYP", "G-Type"},
    {"GXH", "H.G. Font"},
    {"GYST", "Groteskly Yours"},
    {"H", "Hurme Design"},
    {"H&FJ", "Hoefler & Frere-Jones"},
    {"HA", "HoboArt"},
    {"HACO", "HACOLLECTIVE"},
    {"HAD", "Hoffmann Angelic Design"},
    {"Hafo", "Hafonton"},
    {"HAIL", "Hail Design"},
    {"HAL", "HAL Typefaces"},
    {"HALB", "HALBFETT"},
    {"HAMZ", "Hamzeh Naghdi"},
    {"hano", "Hanoded Fonts"},
    {"HanS", "HanStyle"},
    {"HAUS", "TypeHaus"},
    {"HBT", "Harbor Type"},
    {"HCMP", "Happycompany Italy"},
    {"HD", "Hard Type"},
    {"HDCO", "Hanken Design Co."},
    {"HEB", "Sivan Toledo"},
    {"HenT", "Henestrosa Type"},
    {"HERZ", "Herzberg Design Co"},
    {"HEUM", "Heumm Design"},
    {"HEX", "HEX Projects"},
    {"HEYP", "HEY PORTER!"},
    {"HFEW", "Happyfew"},
    {"HFJ", "Hoefler & Frere-Jones (replaced by H&FJ)"},
    {"HH", "Halwote Hareg"},
    {"HIH", "HiH Retrofonts"},
    {"HILL", "Hill Systems"},
    {"HJZ", "Hans J. Zinken"},
    {"HK", "Hadar Katan"},
    {"HKSY", "HAKUSYUFONTS"},
    {"HL", "High-Logic"},
    {"HM", "Haiku Monkey"},
    {"HN", "Hora Nocte Type Foundry"},
    {"HOH", "HOHOHtype"},
    {"Hone", "H-one Design"},
    {"HOOL", "Hooloovoo Studio"},
    {"HoP", "House of Pretty"},
    {"HOUS", "House Industries"},
    {"HoX", "House of X"},
    {"HP", "Hewlett-Packard"},
    {"HS", "HermesSOFT Company"},
    {"HSH", "Hassan Shebli"},
    {"HT", "Huerta Tipográfica"},
    {"HTA", "活字攷古"},
    {"HTF", "The Hoefler Type Foundry, Inc."},
    {"HTT", "Hype Type Type"},
    {"HU", "Hungarumlaut"},
    {"HUY!", "Huy! Fonts"},
    {"HVD", "HVD Fonts GmbH"},
    {"HWT", "Hamilton Wood Typethety"},
    {"HXTP", "Hexatype"},
    {"HY", "HanYang Information & Communication"},
    {"HYPE", "HyperType"},
    {"HYPN", "Heypentype"},
    {"HZ", "Hubert Zasępa"},
    {"IAMT", "IamTiago"},
    {"IB", "Instinctual Beings"},
    {"IBCR", "Ironbird Creative Studio"},
    {"IBM", "IBM"},
    {"IC", "Ian J. Cox"},
    {"IDAU", "IDAutomation.com, Inc."},
    {"IDEA", "Glenn Campbell t/a Idea Studio"},
    {"IDEE", "IDEE TYPOGRAFICA"},
    {"IDF", "International Digital Fonts"},
    {"IDKB", "Kostas Bartsokas"},
    {"IDL", "Identity Lab"},
    {"IDLT", "Identity Letters"},
    {"IDMS", "Incstone Design by Megami Studios"},
    {"Idt.", "Identitype"},
    {"IFF", "Indian Font Factory"},
    {"IINF", "iInformatica Srls"},
    {"IKMJ", "Ikimoji"},
    {"IKOF", "IKOffice GmbH"},
    {"ILP", "Indigenous Languages Project"},
    {"IMPR", "Impress"},
    {"INCD", "INCDesign"},
    {"INDG", "Indigo+Indigo"},
    {"INFS", "iNfernalSoft"},
    {"INGA", "Inga Type"},
    {"INGT", "Ingrimayne Type"},
    {"INNO", "INNO.LLC"},
    {"INRA", "INRAY Inc."},
    {"INTF", "Interfont"},
    {"INTR", "Interstitial Entertainment"},
    {"INVC", "Invoice Central"},
    {"INVD", "TYPE INVADERS"},
    {"INVT", "Invisible Type"},
    {"IRRT", "Irregular Regular"},
    {"ISAC", "Isaco Type"},
    {"ISE", "ISE (devanagarifonts.com)"},
    {"it*", "indestructible type*"},
    {"ITC", "ITC"},
    {"ITF", "Red Rooster Collection (ITF, Inc.)"},
    {"ITFO", "Indian Type Foundry"},
    {"ITSK", "Saki Itomi"},
    {"ITSM", "Simon Stratford"},
    {"IvyF", "The Ivy Foundry"},
    {"IWA", "Iwata Corporation"},
    {"J23", "June 23"},
    {"JAMO", "JAMO"},
    {"JASO", "studioJASO"},
    {"JABM", "JAB'M Foundry"},
    {"JAF", "Just Another Foundry"},
    {"JAKE", "Jake Tilson Studio"},
    {"JAM", "JAM Type"},
    {"JANS", "Jan Šindler"},
    {"JB", "JetBrains"},
    {"JBLT", "JEAN-BAPTISTE LEVÉE TYPOGRAPHY"},
    {"JCF", "Juan Casco Fonts"},
    {"JCT", "Jamie Clarke Type"},
    {"JDB", "Jeff Bensch"},
    {"jeff", "jeff-levine"},
    {"JENS", "Jens Kutilek"},
    {"JF", "Jan Fromm"},
    {"jftw", "justfont"},
    {"JHA", "Jan Henrik Arnold"},
    {"JHF", "JH Fonts"},
    {"JKOB", "Foundry Jakob"},
    {"JLIF", "jli Foundry – Julie Soudanne"},
    {"JMN", "Jeff Napadow"},
    {"JO M", "Jo Malinis"},
    {"JOON", "JoonFont"},
    {"JOT", "Josh Ownby"},
    {"JP", "Jamra Patel"},
    {"JPTT", "Jeremy Tankard Typography Ltd"},
    {"JQKA", "Queen of Spades Design"},
    {"JRW", "Richard Wordingham"},
    {"JSTN", "Justin Penner"},
    {"JT", "Julytype"},
    {"JTD", "JTD Type"},
    {"JUST", "Just in Type"},
    {"JuTy", "JudouEco"},
    {"JVRT", "Just van Rossum Type"},
    {"JWTM", "Type Matters"},
    {"JY", "JIYUKOBO Ltd."},
    {"JYT", "Just Your Type"},
    {"K", "Kvant Type Foundry"},
    {"K&C", "Kerns & Cairns"},
    {"ka", "kloeg architecture"},
    {"KAME", "Kame Design"},
    {"KAPT", "Kaptype"},
    {"KATF", "Kingsley/ATF"},
    {"KBNT", "Kombinat-Typefounders"},
    {"KD", "Kassymkulov Design"},
    {"KDW", "Kinuta Font Factory"},
    {"KERN", "Machine Kerning"},
    {"KEYA", "Keya Vadgama"},
    {"KF", "Karakta Fonthome"},
    {"KFoF", "Kevin Foley Fonts"},
    {"KGLR", "Kugler Industries"},
    {"KH", "Kristy Hatswell"},
    {"KHTB", "Monkey Arts Ltd."},
    {"KHTF", "KH Type"},
    {"KILO", "Kilotype"},
    {"KIRK", "Typekirk"},
    {"KK", "Kiwari Kolektiv Studio"},
    {"KK95", "Kuirnovi Kether"},
    {"klew", "Kent Lew"},
    {"KLIM", "Klim Typographic Design"},
    {"KLNT", "Kowloon Type"},
    {"KLTF", "Karsten Luecke"},
    {"KMR", "kimera"},
    {"KMRS", "Mony Sath & Chhit Wornnarith - KhemaraSoft"},
    {"KNON", "KF Digital Typefaces AB"},
    {"KNST", "Konst.ru"},
    {"KNTR", "Kontour"},
    {"KNWT", "Karl Nawrot"},
    {"KOP", "Leo Koppelkamm"},
    {"KORK", "Khork OÜ"},
    {"KOST", "Kostic Type Foundry"},
    {"KOVL", "Koval Type Foundry"},
    {"KP", "Kontrapunkt"},
    {"KrKo", "Kreative Software"},
    {"KRND", "Karandash Type & Graphics Foundry"},
    {"KSES", "KSE Software"},
    {"KT", "Kalaus Type"},
    {"KTF", "Kustomtype"},
    {"KTKM", "KTKM"},
    {"KTRF", "Kazan Traditional Font"},
    {"KTTF", "Kitchen Table Type Foundry"},
    {"KUBA", "Kuba Tatarkiewicz"},
    {"KUSH", "KushJain"},
    {"KWKK", "キウイ皮ごと齧る"},
    {"L2M3", "L2M3 Kommunikationsdesign GmbH"},
    {"L52", "Lipika52 Type Foundry"},
    {"LA", "Large"},
    {"LADD", "Adam Ladd Design"},
    {"LaG", "Matt LaGrandeur"},
    {"LAGA", "Lagarto"},
    {"laic", "Laïc: Type Foundry"},
    {"LAIT", "la laiterie"},
    {"LAND", "Typeland"},
    {"LANS", "Lanston Type Company"},
    {"LARA", "Larabiefonts"},
    {"LARR", "Larry"},
    {"LArt", "Limelight Artistry"},
    {"LAUD", "Carolina Laudon"},
    {"LAYT", "LAYOUT SARL"},
    {"LBV", "La Bolde Vita"},
    {"LCMT", "Locomotype"},
    {"LDNT", "London Type Foundry"},
    {"LDTP", "Leedotype"},
    {"LEAF", "Interleaf, Inc."},
    {"Leah", "Leah Lackey"},
    {"LECH", "Antonio Lechuga"},
    {"Lee", "Lee Mounsey"},
    {"LEKS", "Leksen Design LLC"},
    {"LETR", "Letraset"},
    {"LETS", "Let’s Type"},
    {"Lev", "Lev Rastvortsev"},
    {"lewd", "Lettering World LLC"},
    {"LFS", "Letters from Sweden"},
    {"LGFF", "LIPIGHOR FONT FOUNDRY"},
    {"LGX", "Logix Research Institute, Inc."},
    {"LHF", "Letterhead Fonts"},
    {"LIAM", "Liam Spradlin"},
    {"LIEB", "LiebeFonts"},
    {"LIGA", "Ligatipo Foundry"},
    {"LIND", "Lindenberg Software LLC"},
    {"LING", "Linguist's Software"},
    {"LINK", "Linkpen Handwriting Fonts"},
    {"LINO", "Linotype GmbH"},
    {"LINZ", "Linda Hintz"},
    {"LIVE", "Livedesign"},
    {"LJ", "Letterjuice"},
    {"LJDS", "LJ Design Studios"},
    {"LKAS", "Shawn Lukas"},
    {"LKTF", "LEE KEDAH"},
    {"LL75", "Lior Livne"},
    {"LLD", "Lipton Letter Design"},
    {"LLDL", "La Lettre de Luxe"},
    {"LLGW", "Laura Worthington Design"},
    {"LLP", "Léna Le Pommelet"},
    {"LMNT", "Element Type"},
    {"LNGU", "LangusteFonts"},
    {"LNTO", "Lineto"},
    {"LOFF", "Logan Font Foundry"},
    {"Log9", "Log9 Foundry"},
    {"LOMT", "The League of Moveable Type"},
    {"LONT", "Lontar GmbH"},
    {"lool", "lo-ol Type"},
    {"LORO", "LoRo Productions"},
    {"LOU", "Lou Type Foundry"},
    {"LOUD", "Loudifier"},
    {"LOVE", "LoveFrom"},
    {"LP", "LetterPerfect Fonts"},
    {"LPKL", "Lipikola Type Foundry"},
    {"LS", "lettersoup"},
    {"LST", "Laucke Siebein Type"},
    {"LT", "Le Typophage"},
    {"LTF", "Liberty Type Foundry"},
    {"LTFD", "Linnea Type"},
    {"LTRK", "Letterka Type Foundry / Olga Kovalenko"},
    {"Ltrm", "Lettermin type and design"},
    {"LTRS", "The Letters"},
    {"LTRX", "Lighttracks"},
    {"LTTR", "LettError"},
    {"LuAn", "Patrice Provost"},
    {"LUDE", "LudwigType"},
    {"LUFF", "Ellen Luff Type Foundry"},
    {"LuRa", "Lucid Rabbit Productions"},
    {"LUD", "Ludlow"},
    {"LuFo", "LucasFonts"},
    {"LUSH", "Lush Type"},
    {"LUV", "iLUVfonts"},
    {"LVRC", "Lovercase"},
    {"LVSC", "Leviathan Science"},
    {"LXGW", "LXGW (落霞孤鹜 / 霞鹜)"},
    {"M", "MARSNEV"},
    {"M+F", "Measure + Fit"},
    {"MACR", "Macromedia / Made with Fontographer"},
    {"MADE", "Marmite Defontes"},
    {"MADT", "MADType"},
    {"MagD", "Magus Digital"},
    {"MAMA", "alimama"},
    {"MANC", "Manchester Type"},
    {"MANS", "Mans Greback AB"},
    {"MAPS", "Tom Mouat's Map Symbol Fonts"},
    {"MARK", "Mark Frömberg"},
    {"MATE", "TypeMates"},
    {"MATF", "Manos Andreakis"},
    {"MATS", "Match Fonts"},
    {"MAW", "Matthew Willsone"},
    {"MAXI", "MaxiType"},
    {"MAXN", "MaxnorType"},
    {"MBF", "Moonbandit font foundry"},
    {"MBJH", "Mutsuba Jouhou"},
    {"MC", "Cerajewski Computer Consulting"},
    {"MCHL", "Michal Sahar"},
    {"MCKL", "MCKL"},
    {"MCL", "My Creative Land"},
    {"MCOW", "Mountaincow"},
    {"MCTF", "Monoco Type Foundry"},
    {"MD", "Mass-Driver"},
    {"MDIV", "Dhivehi Type Foundry"},
    {"MDSN", "Moraitis Design"},
    {"MEAP", "MetaAppz"},
    {"MEEM", "MEEM TYPE"},
    {"MEH", "Steve Mehallo"},
    {"MEIR", "Meir Sadan"},
    {"MESA", "FontMesa,"},
    {"META", "Metatype"},
    {"METZ", "Nathan Metzler"},
    {"MF", "Magic Fonts"},
    {"MFCF", "Make Fun Creating Fonts"},
    {"MFNT", "Masterfont"},
    {"MG", "Milieu Grotesque"},
    {"MGD", "Matt Grey Design"},
    {"MH", "Misti’s Fonts"},
    {"MHED", "McGraw-Hill Education"},
    {"MHMD", "Mohammad Elikaei"},
    {"MHTY", "Minjoo Ham"},
    {"MILL", "Millan"},
    {"MINT", "Mint Type"},
    {"MISS", "Missy Meyer"},
    {"MITF", "Mehras Types"},
    {"MJ", "Liberty Type Foundry"},
    {"MJR", "Majur Inc."},
    {"MJWK", "もじワク研究"},
    {"MKSD", "Maniackers Design"},
    {"MLAG", "Michael LaGattuta"},
    {"MLBU", "Malibu Dream Designs, LLC"},
    {"MLF", "PGML Communications Pty Ltd"},
    {"MLFN", "Monoline Fonts"},
    {"MLFM", "MultiFormis"},
    {"MLGC", "Micrologic Software"},
    {"MLKT", "Mallikātype"},
    {"mlss", "Mark Simonson Studio LLC"},
    {"MLTH", "Monolith"},
    {"MMCG", "Miko McGinty"},
    {"MMFT", "Michel M."},
    {"MMIK", "Monomonnik"},
    {"MMMM", "Martin Majoor"},
    {"MMNG", "MonogramBros"},
    {"MNCK", "Mine Creek"},
    {"MNIC", "manic type"},
    {"mnik", "Mooniak"},
    {"MNJU", "Manjunatha Bengaluru"},
    {"MNKR", "Monokrom Skriftforlag AS"},
    {"MNKY", "Monkey Type"},
    {"MNLF", "Manual Foundry"},
    {"MODI", "Modular Infotech Private Limited."},
    {"MOGT", "MOGTAHID"},
    {"MOHT", "Al Mohtaraf Assaudi Ltd"},
    {"MOJI", "Mojijuku"},
    {"MOLG", "MoolongType"},
    {"MOMI", "Momentum 18"},
    {"MONI", "monitor"},
    {"MONB", "Monib"},
    {"MONE", "Meta One Limited"},
    {"MONO", "Monotype Imaging"},
    {"MOON", "Moonlight Type and Technolog"},
    {"MORF", "morefont"},
    {"MORN", "Morning Type"},
    {"MOSH", "Moshik Nadav Typography"},
    {"MOT", "Multiocular Type"},
    {"MOTA", "Mota Italic"},
    {"MOTF", "Mostardesign Type Foundry SAS"},
    {"MPTG", "Typogama"},
    {"MR", "Michael Rafailyk"},
    {"MRF", "Mac Rhino Fonts"},
    {"MRSL", "Mark Russell"},
    {"MRSW", "Morisawa & Company, Ltd."},
    {"MRV", "Morovia Corporation"},
    {"MS", "Microsoft Corp."},
    {"MSCH", "Guitar-Injection"},
    {"MSCR", "Majus Corporation"},
    {"MSE", "MSE-iT"},
    {"MSPG", "Masterpage"},
    {"MSTK", "Alex Serada"},
    {"MT", "Monotype Imaging (replaced by MONO)"},
    {"MTCO", "Martype Company"},
    {"MTDS", "Multitudes"},
    {"MTF", "Miss Tiina Fonts"},
    {"MTFO", "Music Type Foundry"},
    {"MTMF", "Modern Type"},
    {"MTNT", "Mutant Standard"},
    {"MTY", "Motoya Co. ,LTD."},
    {"MUCC", "muccatypo"},
    {"MUK!", "Mukmonsalve"},
    {"MULT", "mulat"},
    {"MUNC", "munchfonts"},
    {"MUSA", "Musashi System"},
    {"MUTF", "Murasu Systems Sdn. Bhd"},
    {"MVB", "MVB Fonts"},
    {"MVTP", "Mauve Type"},
    {"MVST", "Man Versus Type"},
    {"MVty", "MV Typo"},
    {"MW", "Michael Want"},
    {"MY", "My Type"},
    {"MYFO", "MyFonts.com"},
    {"MYIL", "綿雲飴里"},
    {"MYNT", "Arif Rahman"},
    {"N&G", "Nikish"},
    {"n8", "Nathan Willis"},
    {"nan", "nan"},
    {"NANO", "NANOFONT Inc."},
    {"NASK", "Naske Studio"},
    {"NASR", "Nasir Udin"},
    {"NAUM", "Naumtype"},
    {"NB", "No Bodoni Typography"},
    {"NBR", "Noir Blanc Rouge"},
    {"NBTF", "Norberg Type Foundry"},
    {"ncnd", "&cond"},
    {"NDCT", "Neufville Digital Corporatype"},
    {"NDEF", "Notdef Type"},
    {"NDTC", "Neufville Digital"},
    {"NEAT", "Neatnik"},
    {"NEC", "NEC Corporation"},
    {"NEEC", "Netvarec"},
    {"NERK", "Nermin Kahrimanovic"},
    {"NEUE", "Neue Foundry"},
    {"NEW", "Newlyn"},
    {"NFMS", "Nice Fonts"},
    {"NFSL", "NFSL2001"},
    {"NG", "Nguyen Gobber OG"},
    {"NGMK", "Kousuke Nagai"},
    {"NICE", "nice to type"},
    {"NICK", "Nick's Fonts"},
    {"NICO", "NW digital type foundry"},
    {"NIKO", "Niko uno"},
    {"NIS", "NIS Corporation"},
    {"NITS", "Niteesh Yadav"},
    {"NIVA", "Nivatype"},
    {"nkan", "Nontynet"},
    {"NM", "NM type"},
    {"NMKK", "波間のかけひき (Namima no Kakehiki)"},
    {"NMRK", "Nymark Type"},
    {"NN", "NN Type Foundry"},
    {"NNSS", "NANOFONT-StaticStudios"},
    {"NONO", "Nouvelle Noire Type Foundry"},
    {"NOOT", "Nootype"},
    {"NOPN", "Noponies"},
    {"NorB", "NorFonts.ma"},
    {"NORF", "Norfok Incredible Font Design"},
    {"NORT", "Nort"},
    {"NOSE", "Nose AG"},
    {"NOVA", "NOVATYPE"},
    {"NP", "Nipponia"},
    {"NPD", "Nick Pitscheider"},
    {"MRMN", "M#RM#N FONTS"},
    {"NRON", "Nurrontype"},
    {"NUFO", "Nuform Type"},
    {"NVTF", "Nova Type Foundry"},
    {"NWGH", "newglyph"},
    {"NX", "Noxakar"},
    {"NYCM", "NYC Music Services"},
    {"NYPE", "Naipe Foundry"},
    {"OCC", "Occupant Fonts"},
    {"ODSR", "Oddsorts"},
    {"OFTY", "Office for Typography"},
    {"OGJ", "OGJ Type"},
    {"OHG", "Our House Graphics Inc."},
    {"OHNO", "OH no Type Company"},
    {"OKAY", "Okay Type"},
    {"OLAP", "Overlap Type"},
    {"OMAR", "omar-type foundry"},
    {"OMG", "Omega Type Foundry"},
    {"OMNI", "Omnitype"},
    {"OMNY", "OMNY TYPE"},
    {"Once", "Michael T Neff"},
    {"ONES", "Ones Technology"},
    {"OO", "Outline Online"},
    {"OPTM", "Optimo"},
    {"OPTO", "Opto"},
    {"OPR", "Office of Personal Responsibility"},
    {"OR", "Or Type"},
    {"ORBI", "Orbit Enterprises, Inc."},
    {"ORK1", "Ork1"},
    {"ORNG", "Orange Italic"},
    {"ORTY", "Original Type"},
    {"OSFC", "Out Of Step Font Company"},
    {"OSPF", "OneSevenPointFive"},
    {"OST", "Orange Slice Type"},
    {"OTF", "Order Type Foundry"},
    {"OTLR", "OTLab Rus"},
    {"OTTO", "Otto Type Co."},
    {"OTTS", "OneTen The Studio"},
    {"OTYP", "O-Type"},
    {"OURT", "Ourtype"},
    {"OVER", "Overtype"},
    {"OZTY", "Oz Type"},
    {"P22", "P22 Inc."},
    {"PANA", "Pana Type Studio"},
    {"PAPF", "Pappware Fonts"},
    {"PARA", "ParaType Inc."},
    {"PARK", "Boomi Park"},
    {"pbd0", "Peter Bain"},
    {"PBL", "Publié"},
    {"PBLC", "Public Type"},
    {"PBNG", "Playbeing"},
    {"PCJ", "Minhocossauro Tipografia"},
    {"PDWX", "Parsons Design Workx"},
    {"PEAC", "PeachCreme.com"},
    {"PEAR", "Pear-Socam Softworks"},
    {"PEBL", "Pebblestone Design"},
    {"PECI", "Pecita"},
    {"PETR", "Daria Petrova"},
    {"PF", "Phil's Fonts, Inc."},
    {"PFRM", "Punchform"},
    {"PFV", "Phelan’s Fontastic Ventures"},
    {"PHO", "phospho type foundry"},
    {"PHTM", "Phantom Foundry"},
    {"PILZ", "Tamara Pilz"},
    {"PINT", "PintassilgoPrints"},
    {"PIXL", "Pixilate"},
    {"PIZZ", "pizzadude.dk"},
    {"PKDD", "Philip Kelly Digital Design"},
    {"PLAT", "PLATINUM technology"},
    {"Plau", "Plau"},
    {"PLAY", "Playtype"},
    {"PLN", "Plain Form"},
    {"plnt", "Plantype"},
    {"PMPT", "PampaType font foundry"},
    {"POEM", "Poem"},
    {"POI", "Place of Interest Type Foundry"},
    {"PoW", "Proof of Words"},
    {"PPPR", "Pepper Type"},
    {"PRCH", "Parachute Typefoundry"},
    {"PRFS", "Production First Software"},
    {"PRGR", "Paragraph"},
    {"PRLK", "Emre Parlak"},
    {"PRNM", "Pronama"},
    {"PROD", "Production Type"},
    {"PROT", "PROTOTYPO"},
    {"Prox", "Proxima Software"},
    {"PRTF", "Process Type Foundry"},
    {"PRTP", "Protype Foundry"},
    {"PSG", "Page Studio Graphics"},
    {"PSIS", "PhotoShopIsland.com"},
    {"PSTL", "ps.type.lab"},
    {"PSTP", "Positype"},
    {"pstu", "Pseudonym Type Studio"},
    {"PSY", "PSY/OPS"},
    {"PSYM", "Psymon"},
    {"PT", "Playtype"},
    {"PTF", "Porchez Typofonderie"},
    {"PTHF", "Pathfinders Type Foundry"},
    {"PTMI", "Page Technology Marketing, Inc."},
    {"PTS", "Paavola Type Studio"},
    {"PTYP", "PreussType"},
    {"PUBL", "Public Letters"},
    {"PYRS", "PYRS Fontlab Ltd. / Made with FontLab"},
    {"PYTE", "The Pyte Foundry"},
    {"QMSI", "QMS/Imagen"},
    {"QRAT", "Quadrat Communications"},
    {"QTYP", "Qtypography"},
    {"QUAN", "Quantum Enterprises"},
    {"QUE", "Alerque"},
    {"R667", "Remedy667"},
    {"R777", "SanSLit"},
    {"RAIN", "Rainbird"},
    {"RARE", "Rare Bird Font Foundry"},
    {"RARI", "RAR Illustrations"},
    {"RAWR", "Melvian Foundry"},
    {"RDGR", "Rüdiger"},
    {"RDMK", "RandomMaerks"},
    {"READ", "ReadyType"},
    {"REAL", "Underware"},
    {"RENE", "Studio Rene Bieder"},
    {"RES", "Resultat"},
    {"RETY", "Retype"},
    {"REZ", "Reztype"},
    {"RICK", "Rickner Type"},
    {"RIXF", "FONTRIX Inc."},
    {"RJPS", "Reall Graphics"},
    {"RJST", "Rob Jelinski Studios, llc."},
    {"RJTY", "rojotype"},
    {"RKFN", "R K Fonts"},
    {"RKRD", "REKORD"},
    {"RL", "Ruben Holthuijsen"},
    {"RLTF", "Rebeletter Studios"},
    {"RMU", "RMU TypeDesign"},
    {"RNDY", "randytype"},
    {"ROAD", "Road Research Society"},
    {"ROB", "Robert Janes"},
    {"robo", "Buro Petr van Blokland"},
    {"ROBU", "SC ROBU DESIGN S.R.L."},
    {"ROHH", "ROHH studio"},
    {"ROMA", "Romanée Type Foundry"},
    {"ROST", "Robert Strauch"},
    {"RPTR", "Rampage Raptor"},
    {"RR", "Rüdiger"},
    {"RR41", "Reber R41"},
    {"RRT", "Red Rooster Collection (ITF, Inc.)"},
    {"RSET", "Reset Type Studio"},
    {"RSJ", "RSJ Software"},
    {"RSMS", "Rsms"},
    {"RST", "Rosetta"},
    {"RSZ", "Resistenza Type Foundry"},
    {"RT", "Ritmo"},
    {"RTG", "Roach Typografics"},
    {"rthy", "Arthy"},
    {"RTYP", "REALTYPE, Inc."},
    {"RUDY", "RudynFluffy"},
    {"RUNE", "Rune Revival"},
    {"RVLR", "Revolver Type Foundry"},
    {"RXBN", "Roxaboxen"},
    {"RYHG", "Yanghee Ryu"},
    {"RYOB", "Ryobi Limited"},
    {"RYT", "Ra'ey Type"},
    {"S4TF", "Sed4-Type Foundry"},
    {"sacc", "Saccade SchriftBildWort Fonts"},
    {"SAJA", "Saja Typeworks"},
    {"SALT", "Solonka Type Foundry"},
    {"SAMT", "Samtype"},
    {"SAND", "Sandoll"},
    {"SAPL", "Fonderie sans plomb"},
    {"SATO", "Satori Type"},
    {"SATY", "Samuelstype Design AB"},
    {"SAX", "s.a.x. Software gmbh"},
    {"SB", "Sascha Bente"},
    {"SbB", "Sketchbook B"},
    {"SBFY", "Somebay Foundry"},
    {"SBT", "SelfBuild Type Foundry"},
    {"SBYA", "Shibuya Font"},
    {"SCHF", "Schrift Foundry"},
    {"SCTO", "Schick Toikka"},
    {"SDFF", "StaleyDigital Font Foundry"},
    {"Sdtp", "Sudetype"},
    {"SE", "Stéphane Elbaz"},
    {"Sean", "The FontSite"},
    {"SERF", "Seraphemer Foundry"},
    {"SERP", "Serpentype"},
    {"SF", "Sans Fontières"},
    {"SfC", "Shapes for Cash"},
    {"SFF", "Shilalipi Font Foundry."},
    {"SFS", "Sarumadhu Services Pvt. Ltd."},
    {"SFUN", "Software Union"},
    {"SG", "Scooter Graphics"},
    {"SGNL", "Signal Type Foundry Limited"},
    {"SHAM", "ShamFonts / Shamrock Int."},
    {"SHAN", "Fontsim by Shana Koppel"},
    {"SHFT", "Shift"},
    {"SHMI", "Sharanda"},
    {"SHOT", "Shotype"},
    {"SHOW", "Show Me Fonts"},
    {"SHRB", "Shorba Type Foundry"},
    {"SHRP", "Sharp Type"},
    {"SHS", "Shahab Siavash Studio"},
    {"SHUB", "The Software Hub"},
    {"SHYF", "ShyFoundry Fonts"},
    {"sic", "Skill Information'S' Co., Ltd."},
    {"SIG", "vLetter, Inc"},
    {"SIKI", "Sikifonts"},
    {"SIL", "SIL International (SIL)"},
    {"SIT", "Summit Information Technologies Pvt.Ltd,"},
    {"SK", "Anton Skugarov"},
    {"SKP", "Essqué Productions"},
    {"skz", "Celtic Lady's Fonts"},
    {"SL", "Silesian Letters"},
    {"Slab", "Schriftlabor"},
    {"SLCH", "Sale Character"},
    {"SLDE", "Sergej Lebedev"},
    {"SLFN", "Single Line Fonts"},
    {"SLVK", "PTRSLVK Font Foundry"},
    {"SMC", "Swathanthra Malayalam Computing"},
    {"SMPJ", "Senamirmir Project"},
    {"SN", "SourceNet"},
    {"SNTR", "Sintra Beatz LLC"},
    {"SOBF", "Soren Bakhol Fonts"},
    {"SOHO", "Soft Horizons"},
    {"SOS", "Standing Ovations Software"},
    {"SOTY", "So Type"},
    {"SPFO", "SproetS"},
    {"SPIL", "Spilling Type"},
    {"SPIR", "Spiratype"},
    {"SPT", "Type Forward"},
    {"spty", "supertype"},
    {"SPVT", "Sproviero Type"},
    {"SRC", "Source Foundry"},
    {"SRCE", "Source Type"},
    {"SSFD", "Stefan Stoychev"},
    {"SRFT", "Schrifteria Foundry"},
    {"ssm0", "Siryali Studios"},
    {"SSTK", "Smuss Type Kiosk"},
    {"ST", "SocioType"},
    {"STAI", "Sophia Tai"},
    {"STAN", "Stanley fonts"},
    {"STC", "Sorkin Type Co"},
    {"STCO", "Space Type Continuum"},
    {"STF", "Brian Sooy & Co + Sooy Type Foundry"},
    {"STFD", "snuffletrumper"},
    {"STIX", "The STI Pub Companies"},
    {"STLF", "Studio Lowrie Fonts"},
    {"Stor", "Storm Type Foundry"},
    {"STPE", "Setup Type"},
    {"STyC", "Fobytype Foundry"},
    {"STYK", "Satsuyako"},
    {"STYP", "Stone Type Foundry"},
    {"SUNN", "Sunn"},
    {"SUNW", "sunwalk fontworks"},
    {"SVTD", "Synthview"},
    {"SWEL", "Swell Type"},
    {"SWFT", "Swfte International"},
    {"SWSH", "SHOWASHOTAI Co., Ltd."},
    {"SWTY", "Swiss Typefaces"},
    {"SXRA", "Page42 Type Foundry"},
    {"SYDA", "Shree Muktananda Ashram"},
    {"SyDi", "SyyDai"},
    {"SYN", "SynFonts"},
    {"SYRC", "Syriac Computing Institute"},
    {"SYRF", "Syrian Revolution font"},
    {"SySt", "Syfon Studio"},
    {"szgs", "Szabó Gergely Sándor"},
    {"T&S", "Type & Style"},
    {"T&T", "TYPE&type"},
    {"TAB", "Tabular Type Foundry"},
    {"TAFS", "Taf Studio"},
    {"TAFT", "Tural Alisoy Font"},
    {"tanu", "Tanuki Font"},
    {"TB", "TypeBank Co.,Ltd"},
    {"TBFF", "TrueBlue Font Foundry"},
    {"TBLD", "Typobold"},
    {"TBTF", "TypoBaaz Type Foundry"},
    {"TC", "Typeco"},
    {"TCH", "Darryl Cook"},
    {"TCO", "Type Colony"},
    {"TD", "Typedepot"},
    {"TDBK", "Typeface Design Borys Kosmynka"},
    {"TDFF", "Tour de Force Font Foundry"},
    {"TDFO", "The Designers Foundry"},
    {"TDR", "Tansin A. Darcos & Co."},
    {"TERM", "Terminal Design, Inc."},
    {"TF", "Treacyfaces / Headliners"},
    {"TF3D", "TattooFont3D"},
    {"TFAC", "Typefactory"},
    {"TFND", "Typefounding"},
    {"TFTS", "The Foundry Types"},
    {"TFWD", "Sports Fonts"},
    {"TG", "Tom Grace"},
    {"TGD", "Typo Graphic Design ■ Manuel Viergutz"},
    {"TGIF", "Tegamitype® Foundry"},
    {"TGHT", "TIGHTYPE"},
    {"TGS", "The Good Store"},
    {"THIN", "Thinstroke Design LLC"},
    {"THNA", "Thaana Type Foundry"},
    {"THYH", "Thy Hà"},
    {"TILD", "Tilde, SIA"},
    {"TIME", "TimeType / Timepiece Typefaces"},
    {"TIMO", "Tim Romano"},
    {"TIMR", "Tim Rolands"},
    {"TINY", "Tiny Type Co."},
    {"TIPO", "Tipo"},
    {"TIRO", "Tiro Typeworks"},
    {"TJ", "TJ Trewin"},
    {"TJS", "Typejockeys"},
    {"TKSW", "Takushun Wu"},
    {"Tlab", "PYJ&Typolab (박윤정&타이포랩)"},
    {"TLIN", "Teeline Fonts"},
    {"TM", "Type Mafia"},
    {"TMBR", "TimbreType"},
    {"TMF", "The MicroFoundry"},
    {"TMKL", "Timo Klaavo"},
    {"TMT", "TypeMyType Comm. V."},
    {"TN", "Type Network"},
    {"TNB", "The Northern Block"},
    {"TNOF", "Takayuki Nishida"},
    {"TNOZ", "ToneOZ"},
    {"TNTY", "tntypography"},
    {"TO", "Tondonero"},
    {"TOFU", "Tofu Type Foundry"},
    {"TOKO", "Tokotype"},
    {"TOM6", "tomliou design studio"},
    {"TOPP", "Toppan Inc."},
    {"ToSp", "ToSupply"},
    {"tots", "Type-Ø-Tones"},
    {"TPDP", "Type Department"},
    {"TPMA", "typoma"},
    {"TPOC", "Typeóca"},
    {"TPOP", "Tipos Pereira Type Foundry"},
    {"TPSP", "Type Supply"},
    {"TPTA", "TPTQ Arabic"},
    {"TPTC", "Test Pilot Collective"},
    {"TPTQ", "Typotheque"},
    {"TpTp", "TypeType"},
    {"TPTR", "TYPETR"},
    {"TR", "Type Revivals"},
    {"TRAF", "Traffictype"},
    {"TREE", "Treeflow"},
    {"TRIO", "TrionesType"},
    {"TROL", "The Republic of Letters"},
    {"TROY", "Leinster Type"},
    {"TS", "TamilSoft Corporation"},
    {"TSEN", "Typesenses"},
    {"TSGT", "Tapiwanashe Sebastian Garikayi"},
    {"TSPC", "Typespec Ltd"},
    {"TSTY", "Torleiv Georg Sverdrup"},
    {"TT", "TypeTogether"},
    {"TTC", "Tribby Type Co."},
    {"TTF", "Telugu Type Foundry"},
    {"TTG", "Twardoch Typography"},
    {"TTNC", "Typetanic Fonts"},
    {"TTTT", "TypeUnit"},
    {"TTY", "Tipotype"},
    {"TUDO", "tudotype"},
    {"TWK", "TYPE.WELTKERN®"},
    {"TY", "Typocalypse"},
    {"TYBY", "TYPE TAILORS"},
    {"TYCU", "TypeCulture"},
    {"TYFA", "typofactur"},
    {"TYFR", "typographies.fr"},
    {"TYHA", "TypeHabesha"},
    {"TYMD", "TYPEMADE"},
    {"TYME", "type me! Font Foundry"},
    {"TYPA", "Typadelic"},
    {"TYPB", "Type Brut"},
    {"TYPE", "Type Associates Pty Ltd"},
    {"TYPO", "Typodermic"},
    {"TYPR", "Type Project"},
    {"TYPT", "Typearture"},
    {"TYRE", "typerepublic"},
    {"TYSL", "Type Salon"},
    {"TYSO", "TYSO Type"},
    {"TYSP", "Typespace"},
    {"TYTA", "TYPE TAILORS"},
    {"UA", "UnAuthorized Type"},
    {"UCT", "Undercase Type"},
    {"UFAS", "Unicode Fonts for Ancient Scripts"},
    {"UFCB", "Unforma Club"},
    {"UFDN", "UNDERFOREST DESIGN"},
    {"UKUK", "Ultra Kühl"},
    {"ULA", "Montserrat Typeface"},
    {"UNDS", "Underscore Type"},
    {"UNDT", "ÜNDT"},
    {"UNIC", "Unicode Consortium"},
    {"UNIT", "Universal Thirst"},
    {"UNTP", "Untype"},
    {"UNTY", "Unitype / Universal Typefaces"},
    {"UPUP", "Up Up Creative"},
    {"URW", "URW Type Foundry GmbH"},
    {"USGC", "U.S. Graphics Company"},
    {"USSS", "USSSUAL"},
    {"UT", "Unitype Inc"},
    {"UTF", "Undercase Type Foundry"},
    {"VCTR", "Vectro Type Foundry"},
    {"VEZ", "Victoria Eloise Zunhiga"},
    {"VILE", "Font Monger & Chris Vile Fonts"},
    {"VINT", "Vinterstille"},
    {"VJ", "eDESIGNzone"},
    {"VKP", "Vijay K. Patel"},
    {"VLKF", "Visualogik Technology & Design"},
    {"VLNL", "VetteLetters.nl"},
    {"VLQN", "VLQNC Font Foundry"},
    {"VMT", "VMType"},
    {"VN", "Viktor Nübel Type Design"},
    {"VO", "Violet Office"},
    {"VOG", "Martin Vogel"},
    {"VOL", "Bernd Volmer"},
    {"VOLK", "Radmir Volk"},
    {"VOLT", "volto.one"},
    {"VR", "Victoria Rushton"},
    {"VRED", "Vred Letters"},
    {"VROM", "Vladimir Romanov"},
    {"VS", "VorSicht GmbH"},
    {"VT", "VISUALTYPE SRL"},
    {"VTC", "Vocal Type Co."},
    {"VTF", "Velvetyne Type Foundry"},
    {"VTP", "Quang Manh Nguyen"},
    {"VTYP", "(v) design"},
    {"VVD", "Vintage Voyage Design"},
    {"VZWO", "VZWO | Viktor Zumegen"},
    {"WAFO", "Walden Font Co."},
    {"WALA", "Fontwala"},
    {"WASP", "Wasp Barcode Technologies"},
    {"WATF", "WA"},
    {"WBHE", "Webhance"},
    {"WCYS", "WCYS & Co."},
    {"WEBF", "WebFonts JAPAN Inc."},
    {"WEBR", "WebRain"},
    {"WEI", "Wei Huang"},
    {"WERK", "Fontwerk"},
    {"WF", "Walking Fearless"},
    {"WILL", "Willerstorfer Font Foundry"},
    {"WISE", "WiseType"},
    {"WISH", "Willie Shaw"},
    {"WL", "Writ Large Fonts"},
    {"WM", "Webmakers India"},
    {"WNK", "Wanaka"},
    {"WS", "WS · Schriftmanufaktur"},
    {"WZGF", "WenzhouHanziMakeGroup (温州字工坊)"},
    {"XCON", "IntoTheDesign"},
    {"XFC", "Xerox Font Services"},
    {"xljb", "exljbris Font Foundry"},
    {"XOT", "XO Type Co."},
    {"XOTH", "Xoth Morello"},
    {"XSCR", "Xeroscript"},
    {"XTMS", "Extumus"},
    {"XYZ", "XYZ Type LLC"},
    {"Y&Y", "Y&Y, Inc."},
    {"YADS", "YA Type"},
    {"YDI", "YOONDESIGN Inc."},
    {"YDS", "Yellow Design Studio"},
    {"YERK", "Jeff Yerkey Typography"},
    {"YFFI", "Yfficient Graphic Design and Marketing"},
    {"YMGT", "YMG Type Foundry"},
    {"YN", "Yanone"},
    {"YOFF", "Your Own Font Foundry"},
    {"YOKO", "Yokokaku"},
    {"YOUR", "YourFonts.com"},
    {"YT", "YT Foundry"},
    {"YU", "YU Type"},
    {"YUKI", "Yuki Type Foundry"},
    {"YWFT", "YouWorkForThem"},
    {"YYYY", "Yellow Type Foundry"},
    {"z01", "Jiangxi ZoomlaCMS Soft Co. LTD"},
    {"ZAKZ", "Zakznak"},
    {"ZANE", "Unrender"},
    {"ZeGr", "Zebra Font Factory"},
    {"ZEN!", "A-1 Corp."},
    {"ZERO", "Federico Parra"},
    {"zeta", "Tangram Studio"},
    {"ZIHI", "字嗨"},
    {"ZKZN", "Zakznak"},
    {"ZORN", "Benn Zorn"},
    {"ZP", "Zilap Estudio"},
    {"ZPL", "Zapal"},
    {"ZSFT", "Zsoft"},
    {"ZTFN", "Zetafonts"},

};

#ifndef __GTK_DOC_IGNORE__
#define FONT_MANAGER_NOTICE_ENTRIES G_N_ELEMENTS(FontManagerNoticeData)
#define FONT_MANAGER_VENDOR_ENTRIES G_N_ELEMENTS(FontManagerVendorData)
#endif

