/* SPDX-License-Identifier: MIT */
/* SPDX-FileCopyrightText: (c) Copyright 2026 Andrew Bower <andrew@bower.uk> */

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#include "join.h"

static void f(void *context [[maybe_unused]], pid_t p) {
  printf("%d ", p);
}

int main([[maybe_unused]] int argc, [[maybe_unused]] char *argv[]) {
  char *loc;
  int d;
  int rc = 0;

  if (asprintf(&loc, "/proc/%d/task/%d", 1, 1) == -1)
    goto error;

  if ((d = open(loc, O_DIRECTORY | O_RDONLY)) == -1)
    goto error;
  free(loc);

  rc = for_all_children(d, f, NULL);
  if (rc < 0) {
    errno = -rc;
  }

  close(d);

error:
  if (rc < 0) {
    perror(argv[0]);
    return EXIT_FAILURE;
  } else {
    return EXIT_SUCCESS;
  }
}

