
''' Generated by OTF2 Template Engine '''

import ctypes
import traceback
import sys

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeList import AttributeList
from .Definitions import *
from .Events import *
from .Callbacks import callback_wrapper


class SnapReaderCallbacks(ctypes.Structure):
    pass

def SnapReaderCallbacks_New():
    c_New = conf.lib.OTF2_SnapReaderCallbacks_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(SnapReaderCallbacks)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def SnapReaderCallbacks_Delete(snapReaderCallbacks):
    c_Delete = conf.lib.OTF2_SnapReaderCallbacks_Delete
    c_Delete.argtypes = [ ctypes.POINTER(SnapReaderCallbacks) ]
    c_Delete.restype = None
    return c_Delete(snapReaderCallbacks)

def SnapReaderCallbacks_Clear(snapReaderCallbacks):
    c_Clear = conf.lib.OTF2_SnapReaderCallbacks_Clear
    c_Clear.argtypes = [ ctypes.POINTER(SnapReaderCallbacks) ]
    c_Clear.restype = None
    return c_Clear(snapReaderCallbacks)

def _callback_wrapper(type, func, convert_args=None):
    def wrapper(location, time, userData, attribute_list, *args):
        if userData:
            py_userData = ctypes.cast(userData, ctypes.py_object).value
        else:
            py_userData = None
        try:
            if convert_args is not None:
                args = convert_args(*args)
            if not attribute_list:
                attribute_list = None
            ret = func(location, time, py_userData, attribute_list, *args)
            if ret is None:
                ret = CALLBACK_SUCCESS
        except:
            sys.stderr.write("An unhandled python exception has occurred in an "
                             "OTF2_SnapReaderCallback:\n")
            sys.stderr.write(traceback.format_exc())
            ret = CALLBACK_ERROR
        return ret.value
    return callback_wrapper(func, wrapper, type)

_SnapReaderCallback_FP_Unknown = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_SnapReaderCallback_FP_SnapshotStart = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_SnapReaderCallback_FP_SnapshotEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_SnapReaderCallback_FP_MeasurementOnOff = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, MeasurementMode)

_SnapReaderCallback_FP_Enter = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, RegionRef)

_SnapReaderCallback_FP_MpiSend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_SnapReaderCallback_FP_MpiIsend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_SnapReaderCallback_FP_MpiIsendComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_SnapReaderCallback_FP_MpiRecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_SnapReaderCallback_FP_MpiIrecvRequest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_SnapReaderCallback_FP_MpiIrecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_SnapReaderCallback_FP_MpiCollectiveBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp)

_SnapReaderCallback_FP_MpiCollectiveEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, CollectiveOp, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_SnapReaderCallback_FP_OmpFork = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32)

_SnapReaderCallback_FP_OmpAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, ctypes.c_uint32)

_SnapReaderCallback_FP_OmpTaskCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_SnapReaderCallback_FP_OmpTaskSwitch = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_SnapReaderCallback_FP_Metric = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, MetricRef, ctypes.c_uint8, ctypes.POINTER(Type), ctypes.POINTER(MetricValue))

_SnapReaderCallback_FP_ParameterString = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ParameterRef, StringRef)

_SnapReaderCallback_FP_ParameterInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ParameterRef, ctypes.c_int64)

_SnapReaderCallback_FP_ParameterUnsignedInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ParameterRef, ctypes.c_uint64)

def SnapReaderCallbacks_SetUnknownCallback(snapReaderCallbacks, unknownCallbacks):
    c_SetUnknownCallback = conf.lib.OTF2_SnapReaderCallbacks_SetUnknownCallback
    c_SetUnknownCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_Unknown ]
    c_SetUnknownCallback.restype = ErrorCode
    c_SetUnknownCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_Unknown,
                                         unknownCallback)
    c_SetUnknownCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetSnapshotStartCallback(snapReaderCallbacks, snapshotStartCallback):
    c_SetSnapshotStartCallback = conf.lib.OTF2_SnapReaderCallbacks_SetSnapshotStart
    c_SetSnapshotStartCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_SnapshotStart ]
    c_SetSnapshotStartCallback.restype = ErrorCode
    c_SetSnapshotStartCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_snapshotStart,
                                         snapshotStartCallback)
    c_SetSnapshotStartCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetSnapshotEndCallback(snapReaderCallbacks, snapshotEndCallback):
    c_SetSnapshotEndCallback = conf.lib.OTF2_SnapReaderCallbacks_SetSnapshotEnd
    c_SetSnapshotEndCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_SnapshotEnd ]
    c_SetSnapshotEndCallback.restype = ErrorCode
    c_SetSnapshotEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_snapshotEnd,
                                         snapshotEndCallback)
    c_SetSnapshotEndCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMeasurementOnOffCallback(snapReaderCallbacks, measurementOnOffCallback):
    c_SetMeasurementOnOffCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMeasurementOnOff
    c_SetMeasurementOnOffCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MeasurementOnOff ]
    c_SetMeasurementOnOffCallback.restype = ErrorCode
    c_SetMeasurementOnOffCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_measurementOnOff,
                                         measurementOnOffCallback)
    c_SetMeasurementOnOffCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetEnterCallback(snapReaderCallbacks, enterCallback):
    c_SetEnterCallback = conf.lib.OTF2_SnapReaderCallbacks_SetEnter
    c_SetEnterCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_Enter ]
    c_SetEnterCallback.restype = ErrorCode
    c_SetEnterCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_enter,
                                         enterCallback)
    c_SetEnterCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiSendCallback(snapReaderCallbacks, mpiSendCallback):
    c_SetMpiSendCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiSend
    c_SetMpiSendCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiSend ]
    c_SetMpiSendCallback.restype = ErrorCode
    c_SetMpiSendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiSend,
                                         mpiSendCallback)
    c_SetMpiSendCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiIsendCallback(snapReaderCallbacks, mpiIsendCallback):
    c_SetMpiIsendCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiIsend
    c_SetMpiIsendCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiIsend ]
    c_SetMpiIsendCallback.restype = ErrorCode
    c_SetMpiIsendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiIsend,
                                         mpiIsendCallback)
    c_SetMpiIsendCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiIsendCompleteCallback(snapReaderCallbacks, mpiIsendCompleteCallback):
    c_SetMpiIsendCompleteCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiIsendComplete
    c_SetMpiIsendCompleteCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiIsendComplete ]
    c_SetMpiIsendCompleteCallback.restype = ErrorCode
    c_SetMpiIsendCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiIsendComplete,
                                         mpiIsendCompleteCallback)
    c_SetMpiIsendCompleteCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiRecvCallback(snapReaderCallbacks, mpiRecvCallback):
    c_SetMpiRecvCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiRecv
    c_SetMpiRecvCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiRecv ]
    c_SetMpiRecvCallback.restype = ErrorCode
    c_SetMpiRecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiRecv,
                                         mpiRecvCallback)
    c_SetMpiRecvCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiIrecvRequestCallback(snapReaderCallbacks, mpiIrecvRequestCallback):
    c_SetMpiIrecvRequestCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiIrecvRequest
    c_SetMpiIrecvRequestCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiIrecvRequest ]
    c_SetMpiIrecvRequestCallback.restype = ErrorCode
    c_SetMpiIrecvRequestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiIrecvRequest,
                                         mpiIrecvRequestCallback)
    c_SetMpiIrecvRequestCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiIrecvCallback(snapReaderCallbacks, mpiIrecvCallback):
    c_SetMpiIrecvCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiIrecv
    c_SetMpiIrecvCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiIrecv ]
    c_SetMpiIrecvCallback.restype = ErrorCode
    c_SetMpiIrecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiIrecv,
                                         mpiIrecvCallback)
    c_SetMpiIrecvCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiCollectiveBeginCallback(snapReaderCallbacks, mpiCollectiveBeginCallback):
    c_SetMpiCollectiveBeginCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiCollectiveBegin
    c_SetMpiCollectiveBeginCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiCollectiveBegin ]
    c_SetMpiCollectiveBeginCallback.restype = ErrorCode
    c_SetMpiCollectiveBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiCollectiveBegin,
                                         mpiCollectiveBeginCallback)
    c_SetMpiCollectiveBeginCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMpiCollectiveEndCallback(snapReaderCallbacks, mpiCollectiveEndCallback):
    c_SetMpiCollectiveEndCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMpiCollectiveEnd
    c_SetMpiCollectiveEndCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_MpiCollectiveEnd ]
    c_SetMpiCollectiveEndCallback.restype = ErrorCode
    c_SetMpiCollectiveEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_mpiCollectiveEnd,
                                         mpiCollectiveEndCallback)
    c_SetMpiCollectiveEndCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetOmpForkCallback(snapReaderCallbacks, ompForkCallback):
    c_SetOmpForkCallback = conf.lib.OTF2_SnapReaderCallbacks_SetOmpFork
    c_SetOmpForkCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_OmpFork ]
    c_SetOmpForkCallback.restype = ErrorCode
    c_SetOmpForkCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_ompFork,
                                         ompForkCallback)
    c_SetOmpForkCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetOmpAcquireLockCallback(snapReaderCallbacks, ompAcquireLockCallback):
    c_SetOmpAcquireLockCallback = conf.lib.OTF2_SnapReaderCallbacks_SetOmpAcquireLock
    c_SetOmpAcquireLockCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_OmpAcquireLock ]
    c_SetOmpAcquireLockCallback.restype = ErrorCode
    c_SetOmpAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_ompAcquireLock,
                                         ompAcquireLockCallback)
    c_SetOmpAcquireLockCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetOmpTaskCreateCallback(snapReaderCallbacks, ompTaskCreateCallback):
    c_SetOmpTaskCreateCallback = conf.lib.OTF2_SnapReaderCallbacks_SetOmpTaskCreate
    c_SetOmpTaskCreateCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_OmpTaskCreate ]
    c_SetOmpTaskCreateCallback.restype = ErrorCode
    c_SetOmpTaskCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_ompTaskCreate,
                                         ompTaskCreateCallback)
    c_SetOmpTaskCreateCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetOmpTaskSwitchCallback(snapReaderCallbacks, ompTaskSwitchCallback):
    c_SetOmpTaskSwitchCallback = conf.lib.OTF2_SnapReaderCallbacks_SetOmpTaskSwitch
    c_SetOmpTaskSwitchCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_OmpTaskSwitch ]
    c_SetOmpTaskSwitchCallback.restype = ErrorCode
    c_SetOmpTaskSwitchCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_ompTaskSwitch,
                                         ompTaskSwitchCallback)
    c_SetOmpTaskSwitchCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetMetricCallback(snapReaderCallbacks, metricCallback):
    c_SetMetricCallback = conf.lib.OTF2_SnapReaderCallbacks_SetMetricCallback
    c_SetMetricCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_Metric ]
    c_SetMetricCallback.restype = ErrorCode
    c_SetMetricCallback.errcheck = HandleErrorCode
    def convert_args_metric(metric, number_of_metrics, type_ids_array, metric_values_array):
        type_ids = [type_ids_array[i] for i in range(number_of_metrics)]
        metric_values = [metric_values_array[i] for i in range(number_of_metrics)]
        return metric, type_ids, metric_values
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_Metric,
                                         metricCallback, convert_args_metric)
    c_SetMetricCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetParameterStringCallback(snapReaderCallbacks, parameterStringCallback):
    c_SetParameterStringCallback = conf.lib.OTF2_SnapReaderCallbacks_SetParameterString
    c_SetParameterStringCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_ParameterString ]
    c_SetParameterStringCallback.restype = ErrorCode
    c_SetParameterStringCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_parameterString,
                                         parameterStringCallback)
    c_SetParameterStringCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetParameterIntCallback(snapReaderCallbacks, parameterIntCallback):
    c_SetParameterIntCallback = conf.lib.OTF2_SnapReaderCallbacks_SetParameterInt
    c_SetParameterIntCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_ParameterInt ]
    c_SetParameterIntCallback.restype = ErrorCode
    c_SetParameterIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_parameterInt,
                                         parameterIntCallback)
    c_SetParameterIntCallback(snapReaderCallbacks, wrapped_callback)

def SnapReaderCallbacks_SetParameterUnsignedIntCallback(snapReaderCallbacks, parameterUnsignedIntCallback):
    c_SetParameterUnsignedIntCallback = conf.lib.OTF2_SnapReaderCallbacks_SetParameterUnsignedInt
    c_SetParameterUnsignedIntCallback.argtypes = [ ctypes.POINTER(SnapReaderCallbacks), _SnapReaderCallback_FP_ParameterUnsignedInt ]
    c_SetParameterUnsignedIntCallback.restype = ErrorCode
    c_SetParameterUnsignedIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_SnapReaderCallback_FP_parameterUnsignedInt,
                                         parameterUnsignedIntCallback)
    c_SetParameterUnsignedIntCallback(snapReaderCallbacks, wrapped_callback)

__all__ = [
    'SnapReaderCallbacks',
    'SnapReaderCallbacks_New',
    'SnapReaderCallbacks_Delete',
    'SnapReaderCallbacks_Clear',
    'SnapReaderCallbacks_SetUnknownCallback',
    'SnapReaderCallbacks_SetSnapshotStartCallback',
    'SnapReaderCallbacks_SetSnapshotEndCallback',
    'SnapReaderCallbacks_SetMeasurementOnOffCallback',
    'SnapReaderCallbacks_SetEnterCallback',
    'SnapReaderCallbacks_SetMpiSendCallback',
    'SnapReaderCallbacks_SetMpiIsendCallback',
    'SnapReaderCallbacks_SetMpiIsendCompleteCallback',
    'SnapReaderCallbacks_SetMpiRecvCallback',
    'SnapReaderCallbacks_SetMpiIrecvRequestCallback',
    'SnapReaderCallbacks_SetMpiIrecvCallback',
    'SnapReaderCallbacks_SetMpiCollectiveBeginCallback',
    'SnapReaderCallbacks_SetMpiCollectiveEndCallback',
    'SnapReaderCallbacks_SetOmpForkCallback',
    'SnapReaderCallbacks_SetOmpAcquireLockCallback',
    'SnapReaderCallbacks_SetOmpTaskCreateCallback',
    'SnapReaderCallbacks_SetOmpTaskSwitchCallback',
    'SnapReaderCallbacks_SetMetricCallback',
    'SnapReaderCallbacks_SetParameterStringCallback',
    'SnapReaderCallbacks_SetParameterIntCallback',
    'SnapReaderCallbacks_SetParameterUnsignedIntCallback',
]
