//===-- XtensaSubtarget.h - Define Subtarget for the Xtensa ----*- C++ -*--===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This file declares the Xtensa specific subclass of TargetSubtargetInfo.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_XTENSA_XTENSASUBTARGET_H
#define LLVM_LIB_TARGET_XTENSA_XTENSASUBTARGET_H

#include "XtensaFrameLowering.h"
#include "XtensaISelLowering.h"
#include "XtensaInstrInfo.h"
#include "XtensaRegisterInfo.h"
#include "llvm/CodeGen/TargetSubtargetInfo.h"
#include "llvm/IR/DataLayout.h"
#include "llvm/Target/TargetMachine.h"

#define GET_SUBTARGETINFO_HEADER
#include "XtensaGenSubtargetInfo.inc"

namespace llvm {
class StringRef;

class XtensaSubtarget : public XtensaGenSubtargetInfo {
private:
// Bool members corresponding to the SubtargetFeatures defined in tablegen
#define GET_SUBTARGETINFO_MACRO(ATTRIBUTE, DEFAULT, GETTER)                    \
  bool ATTRIBUTE = DEFAULT;
#include "XtensaGenSubtargetInfo.inc"

  const Triple &TargetTriple;
  XtensaInstrInfo InstrInfo;
  XtensaTargetLowering TLInfo;
  std::unique_ptr<const SelectionDAGTargetInfo> TSInfo;
  XtensaFrameLowering FrameLowering;

  XtensaSubtarget &initializeSubtargetDependencies(StringRef CPU, StringRef FS);

public:
  XtensaSubtarget(const Triple &TT, StringRef CPU, StringRef FS,
                  const TargetMachine &TM);

  ~XtensaSubtarget() override;

  const Triple &getTargetTriple() const { return TargetTriple; }

  const TargetFrameLowering *getFrameLowering() const override {
    return &FrameLowering;
  }
  const XtensaInstrInfo *getInstrInfo() const override { return &InstrInfo; }
  const XtensaRegisterInfo *getRegisterInfo() const override {
    return &InstrInfo.getRegisterInfo();
  }

  const XtensaTargetLowering *getTargetLowering() const override {
    return &TLInfo;
  }

  const SelectionDAGTargetInfo *getSelectionDAGInfo() const override;

  bool hasDensity() const { return HasDensity; }
  bool hasMAC16() const { return HasMAC16; }
  bool hasWindowed() const { return HasWindowed; }
  bool hasBoolean() const { return HasBoolean; }
  bool hasLoop() const { return HasLoop; }
  bool hasSEXT() const { return HasSEXT; }
  bool hasCLAMPS() const { return HasCLAMPS; }
  bool hasNSA() const { return HasNSA; }
  bool hasMINMAX() const { return HasMINMAX; }
  bool hasMul16() const { return HasMul16; }
  bool hasMul32() const { return HasMul32; }
  bool hasMul32High() const { return HasMul32High; }
  bool hasDiv32() const { return HasDiv32; }
  bool hasS32C1I() const { return HasS32C1I; }
  bool hasForcedAtomics() const { return HasForcedAtomics; }
  bool hasSingleFloat() const { return HasSingleFloat; }
  bool hasRegionProtection() const { return HasRegionProtection; }
  bool hasRelocatableVector() const { return HasRelocatableVector; }
  bool hasMiscSR() const { return HasMiscSR; }
  bool hasExtendedL32R() const { return HasExtendedL32R; }
  bool hasDataCache() const { return HasDataCache; }
  bool hasHighPriInterrupts() const { return HasHighPriInterrupts; }
  bool hasHighPriInterruptsLevel3() const { return HasHighPriInterruptsLevel3; }
  bool hasHighPriInterruptsLevel4() const { return HasHighPriInterruptsLevel4; }
  bool hasHighPriInterruptsLevel5() const { return HasHighPriInterruptsLevel5; }
  bool hasHighPriInterruptsLevel6() const { return HasHighPriInterruptsLevel6; }
  bool hasHighPriInterruptsLevel7() const { return HasHighPriInterruptsLevel7; }
  bool hasInterrupt() const { return HasInterrupt; }
  bool hasException() const { return HasException; }
  bool hasTHREADPTR() const { return HasTHREADPTR; }
  bool isWindowedABI() const { return hasWindowed(); }

  // Automatically generated by tblgen.
  void ParseSubtargetFeatures(StringRef CPU, StringRef TuneCPU, StringRef FS);
};
} // end namespace llvm

#endif /* LLVM_LIB_TARGET_XTENSA_XTENSASUBTARGET_H */
