% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_xkcdpath.R
\name{geom_xkcdpath}
\alias{geom_xkcdpath}
\title{GeomXkcdPath: fuzzy path/circle geom (XKCD style)}
\usage{
geom_xkcdpath(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  xjitteramount = 0.01,
  yjitteramount = 0.01,
  mask = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Aesthetic mapping.}

\item{data}{Data frame.}

\item{stat}{The statistical transformation to use on the data for this layer.}

\item{position}{Position adjustment.}

\item{...}{Other arguments passed on to layer().}

\item{xjitteramount}{Horizontal jitter amount for segments.}

\item{yjitteramount}{Vertical jitter amount for segments.}

\item{mask}{Logical; if TRUE draws a thicker white mask path under the main path.}

\item{show.legend}{Show legend.}

\item{inherit.aes}{Whether to inherit aesthetics from the plot.}
}
\description{
A ggplot2 geom that draws jittered, smoothed paths or fuzzy circles. It
expects aesthetics like `x`, `y`, and either `xend`/`yend` (for segments) or
`diameter` (for circles). Additional aesthetics (colour, alpha,
linewidth, linetype) are respected.
}
