% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{add_path}
\alias{add_path}
\title{Overlay paths of interpolation on the sphere}
\usage{
add_path(proj_space, path)
}
\arguments{
\item{proj_space}{n number of points on the surface of sphere}

\item{path}{interpolated path}
}
\value{
data frame with interpolated path and points on sphere surface
}
\description{
Overlay paths of interpolation on the sphere
}
\examples{
p <- 4
base1 <- tourr::basis_random(p, d=1)
base2 <- tourr::basis_random(p, d=1)
path <- woylier::givens_full_path(base1, base2, nsteps=10)
sp <- woylier::generate_space_view(p=p)
sp_path <- woylier::add_path(sp, path)
tourr::animate_xy(sp_path[,1:4], col=sp_path$type)
}
