% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-query-type.R
\name{new_list_query}
\alias{new_list_query}
\alias{new_list_query.list}
\alias{new_list_query.generator}
\alias{new_list_query.prop}
\alias{new_list_query.query}
\title{Constructor for \href{https://www.mediawiki.org/wiki/API:Lists}{list} queries}
\usage{
new_list_query(.req, list, ...)

\method{new_list_query}{list}(.req, list, ...)

\method{new_list_query}{generator}(.req, list, ...)

\method{new_list_query}{prop}(.req, list, ...)

\method{new_list_query}{query}(.req, list, ...)
}
\arguments{
\item{.req}{A \code{\link[=wiki_action_request]{query/action_api/httr2_request}}
object, or a \code{list/query/action_api/httr2_request} as returned by this
function.}

\item{list}{The \href{https://www.mediawiki.org/wiki/API:Lists}{list module} to
add to the query}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Parameters to the list module}
}
\value{
An object of type \code{list/query/action_api/httr2_request}.
}
\description{
This low-level constructor only performs basic type checking.
}
\examples{
# Create a query to list all members of Category:Physics
physics_query <- wiki_action_request() \%>\%
  new_list_query("categorymembers", cmtitle="Category:Physics")

}
\keyword{low_level_action_api}
