% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isovist.R
\name{get_viewpoints}
\alias{get_viewpoints}
\title{Get viewpoints from an arbitrary geometry}
\usage{
get_viewpoints(x, density = 1/50)
}
\arguments{
\item{x}{object of class sf, sfc or sfg}

\item{density}{number of points per distance unit}
}
\value{
object of class sfc_POINT
}
\description{
Generate a discrete set of points on the given geometry. If the geometry is
a (MULTI)POLYGON, points are generated on its boundary.
}
\examples{
line <- sf::st_linestring(cbind(c(-1, 1), c(0, 0)))
get_viewpoints(line, density = 5)

}
