% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource.R
\docType{class}
\name{resource}
\alias{resource}
\title{Resource}
\description{
This is an object that represents a single resource.
}
\section{Methods}{

\describe{
\item{\code{initialize()}}{Create a new resource}
\item{\code{as_table()}}{Represents the current state of the resource as a tibble}
}
Creates a new resource.
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{The name of the resource}

\item{\code{quantity}}{The quantity of the resource that exists}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-resource-new}{\code{resource$new()}}
\item \href{#method-resource-as_table}{\code{resource$as_table()}}
\item \href{#method-resource-clone}{\code{resource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource-new"></a>}}
\if{latex}{\out{\hypertarget{method-resource-new}{}}}
\subsection{Method \code{new()}}{
Creates a new resource object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource$new(name = NA, quantity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the resource}

\item{\code{quantity}}{The quantity present
Returns a data.frame representation of the resource}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource-as_table"></a>}}
\if{latex}{\out{\hypertarget{method-resource-as_table}{}}}
\subsection{Method \code{as_table()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource$as_table()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.frame of resources
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-resource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{resource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
