% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cylindrical_surface3d.R
\name{cylindrical_surface3d}
\alias{cylindrical_surface3d}
\title{Ruled surface along a 3D parametric curve}
\usage{
cylindrical_surface3d(
  X,
  Y,
  Z,
  a,
  b,
  s_range,
  dir,
  n_t = 200,
  n_s = 60,
  plot = FALSE,
  surface_colorscale = "Blues",
  surface_opacity = 0.35,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  show_curve = TRUE,
  curve_line = list(color = "red", width = 2, dash = "solid"),
  show_edge_a = TRUE,
  show_edge_b = FALSE,
  edge_line = list(color = "blue", width = 2, dash = "solid"),
  show_rulings = TRUE,
  rulings_count = 12,
  rulings_at = NULL,
  rulings_line = list(color = "black", width = 1, dash = "solid"),
  show_axis_grid = FALSE,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white"),
  lighting = list(ambient = 1, diffuse = 0.15, specular = 0, roughness = 1, fresnel = 0)
)
}
\arguments{
\item{X, Y, Z}{Functions of one variable \code{t} returning the coordinate
components of the base curve.}

\item{a, b}{Numeric values giving the endpoints of the parameter interval.}

\item{s_range}{Numeric vector of length two giving the lower and upper
bounds for the ruling parameter.}

\item{dir}{Numeric vector of length three \code{c(ux, uy, uz)} giving
the ruling direction. It will be normalized internally.}

\item{n_t, n_s}{Integers giving the sampling resolution along the \code{t}
and \code{s} directions.}

\item{plot}{Logical; if \code{TRUE}, displays the ruled surface using
\pkg{plotly}.}

\item{surface_colorscale}{Character string or vector specifying the
colorscale used for the surface.}

\item{surface_opacity}{Numeric value between 0 and 1 controlling the
opacity of the surface.}

\item{show_surface_grid}{Logical; if \code{TRUE}, draws grid lines on the
surface.}

\item{surface_grid_color}{Color for the surface grid lines.}

\item{surface_grid_width}{Numeric width for the grid lines.}

\item{show_curve}{Logical; if \code{TRUE}, overlays the generating curve.}

\item{curve_line}{List of \pkg{plotly} style options for the curve.}

\item{show_edge_a, show_edge_b}{Logical; if \code{TRUE}, draws the boundary
edges at the extremes of the ruling parameter.}

\item{edge_line}{List of \pkg{plotly} style options for boundary edges.}

\item{show_rulings}{Logical; if \code{TRUE}, draws a subset of rulings on
the surface.}

\item{rulings_count}{Integer giving the number of rulings to draw when
\code{rulings_at} is not provided.}

\item{rulings_at}{Optional numeric vector giving the parameter values at
which rulings should be displayed.}

\item{rulings_line}{List of \pkg{plotly} style options for displayed
rulings.}

\item{show_axis_grid}{Logical; if \code{TRUE}, shows axis gridlines in the
3D scene.}

\item{scene}{Optional list with 3D scene settings for \pkg{plotly}.}

\item{bg}{Optional list with background color settings for the figure.}

\item{lighting}{Optional list with lighting parameters for surface
shading in \pkg{plotly}.}
}
\value{
A list with:
\itemize{
\item \code{t_seq}, \code{s_seq}: parameter grids used to build the mesh,
\item \code{Xmat}, \code{Ymat}, \code{Zmat}: matrices of coordinates
for the ruled surface,
\item \code{curve}: data frame with the sampled generating curve,
\item \code{edge_a}, \code{edge_b}: data frames for boundary edges
(possibly \code{NULL} if not requested),
\item \code{u_hat}: normalized ruling direction vector.
}
}
\description{
Constructs a ruled surface generated by a three-dimensional parametric
curve and a chosen direction field. At each sampled point on the curve,
a straight segment is extended in a specified direction, producing a
surface composed of line elements. Optionally, the resulting surface can
be visualized using \pkg{plotly}.
}
\details{
The function samples the base curve at \code{n_t} parameter values and,
for each sampled point, generates a set of points along a line segment
determined by the ruling parameter. These segments are interpolated over
the interval specified in \code{s_range}.

In this implementation, the ruling direction is given by a fixed
three-dimensional vector \code{dir}. This vector is normalized
internally before constructing the surface.

If \code{plot = TRUE}, a 3D visualization is produced using \pkg{plotly}.
The plot may include the ruled surface, grid lines on the surface,
boundary edges corresponding to the extremes of the ruling parameter,
and a selection of rulings. The generating curve can also be displayed.
}
\examples{
X <- function(t) cos(t)
Y <- function(t) sin(t)
Z <- function(t) 0.3 * t
dir_vec <- c(0, 0, 1)
rs <- cylindrical_surface3d(
  X, Y, Z,
  a = 0, b = 2 * pi,
  s_range = c(-0.2, 0.2),
  dir = dir_vec,
  n_t = 100, n_s = 40,
  plot = FALSE
)

}
