% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.loglm.R
\name{logLik.loglm}
\alias{logLik.loglm}
\title{Log-Likelihood of a loglm Object}
\usage{
\method{logLik}{loglm}(object, ..., zero = 1e-10)
}
\arguments{
\item{object}{A \code{loglm} object}

\item{\dots}{For compatibility with the S3 generic; not used here}

\item{zero}{value used to replace zero frequencies in calculating the
log-likelihood}
}
\value{
Returns an object of class \code{logLik}.  This is a number with one
attribute, \code{"df"} (degrees of freedom), giving the number of
(estimated) parameters in the model.
}
\description{
Calculates the log-likelihood value of the \code{loglm} model represented by
\code{object} evaluated at the estimated coefficients.
}
\details{
It allows the use of \code{\link[stats]{AIC}} and \code{\link[stats]{BIC}},
which require that a \code{logLik} method exists to extract the
corresponding log-likelihood for the model.

If cell frequencies have not been stored with the \code{loglm} object (via
the argument \code{keep.frequencies = TRUE}), they are obtained using
\code{update}.

This function calculates the log-likelihood in a way that allows for
non-integer frequencies, such as the case where 0.5 has been added to all
cell frequencies to allow for sampling zeros.  If the frequencies still
contain zero values, those are replaced by the value of \code{start}.

For integer frequencies, it gives the same result as the corresponding model
fit using \code{\link[stats]{glm}}, whereas \code{\link[stats]{glm}} returns
\code{-Inf} if there are any non-integer frequencies.
}
\examples{

data(Titanic, package="datasets")

require(MASS)
titanic.mod1 <- loglm(~ (Class * Age * Sex) + Survived, data=Titanic)
titanic.mod2 <- loglm(~ (Class * Age * Sex) + Survived*(Class + Age + Sex), data=Titanic)
titanic.mod3 <- loglm(~ (Class * Age * Sex) + Survived*(Class + Age * Sex), data=Titanic)

logLik(titanic.mod1)
AIC(titanic.mod1, titanic.mod2, titanic.mod3)
BIC(titanic.mod1, titanic.mod2, titanic.mod3)

# compare with models fit using glm()
titanic <- as.data.frame(Titanic)
titanic.glm1 <- glm(Freq ~ (Class * Age * Sex) + Survived,
                    data=titanic, family=poisson)
titanic.glm2 <- glm(Freq ~ (Class * Age * Sex) + Survived*(Class + Age + Sex),
                    data=titanic, family=poisson)
titanic.glm3 <- glm(Freq ~ (Class * Age * Sex) + Survived*(Class + Age * Sex),
                    data=titanic, family=poisson)

logLik(titanic.glm1)
AIC(titanic.glm1, titanic.glm2, titanic.glm3)
BIC(titanic.glm1, titanic.glm2, titanic.glm3)


}
\seealso{
\code{\link[MASS]{loglm}}, \code{\link[stats]{AIC}},
\code{\link[stats]{BIC}},
}
\author{
Achim Zeileis
}
\keyword{htest}
\keyword{models}
