% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{create_mundlak_data}
\alias{create_mundlak_data}
\title{Create Mundlak-Transformed Panel Data}
\usage{
create_mundlak_data(panel_data, x_var = "log_direct")
}
\arguments{
\item{panel_data}{Data frame with panel data.}

\item{x_var}{Character string. Name of the explanatory variable.
Default "log_direct".}
}
\value{
Panel data with additional columns:
\describe{
  \item{x_mean_sector}{Sector-level mean of x_var}
  \item{x_within}{Within-sector deviation (x - sector mean)}
}
}
\description{
Adds sector-level means and within-deviations for Mundlak/CRE estimation.
}
\examples{
set.seed(123)
panel <- data.frame(
  year = rep(2000:2002, 3),
  sector = rep(c("A", "B", "C"), each = 3),
  log_direct = rnorm(9, mean = 5),
  log_production = rnorm(9, mean = 5)
)
panel_mundlak <- create_mundlak_data(panel)
head(panel_mundlak)

}
