% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_biomarkers_user.R
\name{compute_extended_ratios}
\alias{compute_extended_ratios}
\title{Compute extended set of biomarker ratios}
\usage{
compute_extended_ratios(x)
}
\arguments{
\item{x}{\code{data.frame} containing NMR metabolomics data from UK Biobank.
May either be raw field data output by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
or data with column names corresponding to biomarkers listed in \code{\link{nmr_info}}.}
}
\value{
a \code{data.frame} with the additional computed biomarker ratios.
}
\description{
Computes 76 additional ratios not provided by the Nightingale platform. These
include lipid fractions in HDL, LDL, VLDL, and total serum, as well as
cholesterol fractions, and omega to polyunsaturated fatty acid ratios. See
\code{\link{nmr_info}} for details.
}
\details{
If your UK Biobank project only has access to a subset of biomarkers, then
this function will only return the subset of ratios that can be computed from
the biomarker data provided.

All biomarkers in the input data are also returned alongside the ratios computed
by this function.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
nmr <- compute_extended_ratios(ukb_data)

}
\seealso{
\code{\link{nmr_info}} for list of computed biomarker ratios,
  \code{\link{compute_extended_ratio_qc_flags}()} for obtaining an
  aggregate of the biomarker QC flags from the biomarkers underlying each
  computed ratio, and \code{\link{extract_biomarkers}()} for details on how
  raw data from
  \href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
  is processed.
}
