% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power2Continuous.R
\name{power2Continuous}
\alias{power2Continuous}
\title{Power Calculation for Two Co-Primary Continuous Endpoints}
\usage{
power2Continuous(
  n1,
  n2,
  delta1,
  delta2,
  sd1,
  sd2,
  rho,
  alpha,
  known_var = TRUE,
  nMC = 10000
)
}
\arguments{
\item{n1}{Sample size for group 1 (test group)}

\item{n2}{Sample size for group 2 (control group)}

\item{delta1}{Mean difference for the first endpoint}

\item{delta2}{Mean difference for the second endpoint}

\item{sd1}{Common standard deviation for the first endpoint}

\item{sd2}{Common standard deviation for the second endpoint}

\item{rho}{Common correlation between the two outcomes}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{known_var}{Logical value indicating whether variance is known (TRUE) or
unknown (FALSE). If TRUE, power is calculated analytically; otherwise,
Monte Carlo simulation is used for unknown variance}

\item{nMC}{Number of Monte Carlo simulations when known_var = FALSE (default is 10000)}
}
\value{
A data frame with the following columns:
\item{n1}{Sample size for group 1}
\item{n2}{Sample size for group 2}
\item{delta1}{Mean difference for endpoint 1}
\item{delta2}{Mean difference for endpoint 2}
\item{sd1}{Standard deviation for endpoint 1}
\item{sd2}{Standard deviation for endpoint 2}
\item{rho}{Correlation between endpoints}
\item{alpha}{One-sided significance level}
\item{known_var}{Variance assumption}
\item{nMC}{Number of Monte Carlo simulations (NA if known_var = TRUE)}
\item{power1}{Power for the first endpoint alone}
\item{power2}{Power for the second endpoint alone}
\item{powerCoprimary}{Power for both co-primary endpoints}
}
\description{
Calculates the power for a two-arm superiority trial with two co-primary
continuous endpoints, as described in Sozu et al. (2011).
}
\details{
For known variance, the power is calculated using the bivariate normal distribution
as described in Sozu et al. (2011). The test statistics are:
\deqn{Z_k = \frac{\delta_k}{\sigma_k \sqrt{1/n_1 + 1/n_2}}}
for k = 1, 2. The co-primary power is:
\deqn{1 - \beta = \Phi_2\left(-z_{1-\alpha} + Z_1, -z_{1-\alpha} + Z_2 \mid \rho\right)}
where \eqn{\Phi_2} is the cumulative distribution function of the bivariate
standard normal distribution.

For unknown variance, Monte Carlo simulation is used with Wishart-distributed
variance-covariance matrices to account for variance estimation uncertainty,
following equation (6) in Sozu et al. (2011):
\deqn{\text{Power} = E_W\left[\Phi_2(-c_1^*\sqrt{w_{11}}, -c_2^*\sqrt{w_{22}} | \rho)\right]}
where \eqn{c_k^* = t_{\alpha,\nu}\sqrt{\frac{1}{\nu}} - \frac{Z_k}{\sqrt{w_{kk}}}} and
\eqn{W} follows a Wishart distribution with \eqn{\nu = n_1 + n_2 - 2} degrees of freedom.
}
\examples{
# Example parameters for comparison across methods
n1_ex <- 100
n2_ex <- 100
delta1_ex <- 0.5
delta2_ex <- 0.5
sd1_ex <- 1
sd2_ex <- 1
rho_ex <- 0.3
alpha_ex <- 0.025

# Power calculation with known variance
power2Continuous(
  n1 = n1_ex,
  n2 = n2_ex,
  delta1 = delta1_ex,
  delta2 = delta2_ex,
  sd1 = sd1_ex,
  sd2 = sd2_ex,
  rho = rho_ex,
  alpha = alpha_ex,
  known_var = TRUE
)

\donttest{
# Power calculation with unknown variance (Monte Carlo)
power2Continuous(
  n1 = n1_ex,
  n2 = n2_ex,
  delta1 = delta1_ex,
  delta2 = delta2_ex,
  sd1 = sd1_ex,
  sd2 = sd2_ex,
  rho = rho_ex,
  alpha = alpha_ex,
  known_var = FALSE,
  nMC = 10000
)
}

}
\references{
Sozu, T., Sugimoto, T., & Hamasaki, T. (2011). Sample size determination in
superiority clinical trials with multiple co-primary correlated endpoints.
\emph{Journal of Biopharmaceutical Statistics}, 21(4), 650-668.
}
