% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_treatment_eff.R
\name{surv.treatment.eff}
\alias{surv.treatment.eff}
\title{Fit CIFs using treatment policy strategy for competing risks data, based on efficient influence functions}
\usage{
surv.treatment.eff(A, Time, cstatus, X = NULL)
}
\arguments{
\item{A}{Treatment indicator, 1 for treatment and 0 for control.}

\item{Time}{Time to event.}

\item{cstatus}{Indicator of event, 1 for the primary event, 2 for the intercurrent event, 0 for censoring.}

\item{X}{Baseline covariates.}
}
\value{
A list including
\describe{
\item{time1}{Time points in the treated group.}
\item{time0}{Time points in the control group.}
\item{cif1}{Estimated cumulative incidence function in the treated group.}
\item{cif0}{Estimated cumulative incidence function in the control group.}
\item{se1}{Standard error of the estimated cumulative incidence function in the treated group.}
\item{se0}{Standard error of the estimated cumulative incidence function in the control group.}
\item{time}{Time points in both groups.}
\item{ate}{Estimated treatment effect (difference in cumulative incidence functions).}
\item{se}{Standard error of the estimated treatment effect.}
\item{p.val}{P value of testing the treatment effect based on the efficient influence function
of the restricted mean survival time lost by the end of study.}
}
}
\description{
This function estimates the potential cumulative incidence function based on efficient
influence functions using treatment policy strategy (competing risks data structure). Cox models are
employed for the survival model. This strategy ignores the intercurrent event and uses the time to
the primary event as it was recorded.
}
\details{
\describe{
The treatment policy strategy addresses the problem of intercurrent events by expanding
the initial treatment conditions to a treatment policy. This strategy is applicable
only if intercurrent events do not hinder primary outcome events. The treatments under
comparison are now two treatment policies: \eqn{(w, R(w))}, where \eqn{w = 1, 0}. One policy
\eqn{(1,R(1))} involves administering the test drug, along with any naturally occurring
intercurrents, whereas the other policy \eqn{(0,R(0))} involves administering a placebo,
along with any naturally occurring intercurrents. Thus, the potential outcomes are
\eqn{T(1,R(1))} and \eqn{T(0,R(0))}. Instead of comparing the test drug and placebo themselves,
the contrast of interest is made between the two treatment policies. The difference in
cumulative incidences under the two treatment policies is then
\eqn{\tau(t) = P(T(1, R(1)) < t) - P(T(0, R(0)) < t),}{ATE_tp}
representing the difference in probabilities of experiencing primary outcome events during
\eqn{(0,t)} under active treatment and placebo. \cr
The average treatment effect \eqn{\tau^{\text{tp}}(t)} has a meaningful causal interpretation
only when \eqn{T(1, R(1))} and \eqn{T(0, R(0))} are well defined. Because the treatment policy
includes the occurrence of the intercurrent event as natural, the entire treatment policy is
determined by manipulating the initial treatment condition $w$ only. Therefore, we can simplify
the notations \eqn{T(w, R(w)) = T(w)} in defining estimands. As such,
\eqn{\tau(t) = P(T(1)) < t) - P(T(0) < t)} as the intention-to-treat analysis.
}
}
\seealso{
\code{\link[tteICE]{surv.treatment}}, \code{\link[tteICE]{surv.tteICE}}
}
