% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_sample.R
\name{ts_sample}
\alias{ts_sample}
\title{Time Series Sample}
\usage{
ts_sample(ts, test_size = 1, offset = 0)
}
\arguments{
\item{ts}{A \code{ts_data} matrix.}

\item{test_size}{Integer. Number of rows in the test split (default = 1).}

\item{offset}{Integer. Offset from the end before the test split (default = 0).}
}
\value{
A list with \verb{$train} and \verb{$test} (both \code{ts_data}).
}
\description{
Split a \code{ts_data} into train and test sets.

Extracts \code{test_size} rows from the end (minus an optional \code{offset}) as the
test set. The remaining initial rows form the training set. The \code{offset}
is useful to reproduce experiments with different forecast origins.
}
\examples{
# Setting up a ts_data and making a temporal split
# Load example dataset and build windows
data(tsd)
ts <- ts_data(tsd$y, 10)

# Separating into train and test
test_size <- 3
samp <- ts_sample(ts, test_size)

# First five rows from training data
ts_head(samp$train, 5)

# Last five rows from training data
ts_head(samp$train[-c(1:(nrow(samp$train)-5)),])

# Testing data
ts_head(samp$test)
}
