#' Simulated Time Series Dataset
#'
#' This dataset contains a simulated time series dataset for two individuals
#' generated using the \code{graphicalVAR} package. The dataset is useful for testing
#' and demonstrating the functionality of the package.
#'
#' @format ## `ts_data` A data frame with 500 rows and 7 columns.
#' \describe{
#'   \item{id}{A character string identifier for the individual. There are two unique ids, representing two individuals.}
#'   \item{V1-V6}{These columns represent six different variables in the time series data.}
#'   }
#' @source Simulated using the \code{\link[graphicalVAR]{graphicalVARsim}} function in the \code{graphicalVAR} package.
#'
#' @usage data(ts_data)
#'
#' @details
#' The dataset consists of 250 observations each of 6 variables for two individuals.
#' The variables V1-V6 represent simulated time series data generated using the graphicalVARsim function from the graphicalVAR package.
#' The 'id' column contains a character string as identifier of the two individuals.
#' The data have been standardized  to have zero mean and unit variance.
#'
#'
#' @keywords dataset
"ts_data"



#' Example Posterior Samples
#'
#' This dataset contains posterior samples of beta coefficients and partial correlations for two individuals.
#' It was generated by fitting a GVAR model using \code{\link{stan_gvar}} with three variables from the \code{\link{ts_data}} dataset.
#'
#' @format ## `fit_data`
#' A list with two elements, each containing posterior samples for one individual.
#'
#' @usage data(fit_data)
#'
#' @source The data is generated using the \code{\link{stan_gvar}} function on subsets
#' of the \code{\link{ts_data}} time series data.
#'
#' @details
#' The list contains two elements, each containing posterior samples for one individual.
#' The samples were extracted using the \code{\link{stan_fit_convert}} function.
#' For each individual, the list elements contain the posterior means of the beta coefficients
#' ("beta_mu") and the posterior means of the partial correlations ("pcor_mu").
#' The "fit" element contains all 1000 posterior samples of the beta coefficients and partial correlations.
#'
#'
#' @keywords dataset
"fit_data"

